<html>

<head>
    <meta charset="utf-8">
    <title>Customer Invoice</title>
    <link rel="stylesheet" href="<?php echo e(asset('/ivassets/css/style.css')); ?>">
</head>

<body>
   <div class="page">
        <header>
            <!-- <h1><b contenteditable>INVOICE</b></h1> -->
            <div class="flexbox">
                <div class="logo">
                    <img src="<?php echo e(asset('images/logo.png')); ?>" alt="logo" >
                </div>
            <?php $__currentLoopData = $oudatas['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $oudata): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="sender">
                    <!-- <h1 contenteditable>Logos </h1> -->
                    <p> 
                        <?php echo e($oudata['firstname']); ?> <?php echo e($oudata['lastname']); ?> <br>
                        <?php echo e($oudata['phoneno']); ?> <br>
                        <!--email-->
                    </p>
                </div>
                <div class="sender">
                    <p>
                        <?php echo e($oudata['street']); ?> <br>
                       <?php echo e($oudata['city']); ?>, <?php echo e($oudata['state']); ?>

                    </p>
                </div>
            </div>
        </header>
        <div class="flexbox invoice-details">
            <div class="recipient">
                <h3><b>Bill to</b></h3>
                <p>
					<?php if($oudata['company'] == ""): ?>
					<?php else: ?>
					<?php echo e($oudata['company']); ?> <br> 
					<?php endif; ?>
                    <?php echo e($oudata['firstname']); ?> <?php echo e($oudata['lastname']); ?> <br> 
                    <?php echo e($oudata['street']); ?> <br>
                    <?php echo e($oudata['city']); ?>, <?php echo e($oudata['state']); ?>, <?php echo e($oudata['zip']); ?>

                </p>
            </div>
            
          
            <div>
                <h3><b>Invoice Number</b></h3>
                <p>#<?php echo e($oudata['order_id']); ?></p>
                <h3><b>Deduction Commencement Date</b></h3>
                <p data-today><?php echo e($oudata['created_at']); ?></p>
            </div>
            <div>
                <h3><b>Total invoice</b></h3>
                <h1><span class="total">&#x20A6;<?php echo e(number_format($oudata['ototal'],2)); ?></span></h1>
				<button type="button" style="padding:9px;border-radius:9px;background-color:#e00000;color:white;cursor:pointer" title="Print Invoice" onclick="window.print()">Print Invoice</button>
            </div>
			
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
       <h3 style="font-weight:bold">Other Details</h3>
         <br>
      <div style="border: 2px solid #e00000; padding: 10px; border-radius:9px;">
        <div style="font-size: 15px;">
                <p>
                <?php $__currentLoopData = $custdata['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cd): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<span style="font-weight:bold">IPPIS NO:</span> <?php echo e($cd['ippis']); ?> <br><br> 
                    <span style="font-weight:bold">EMPLOYMENT:</span> <?php echo e($cd['employment_status']); ?> <br><br>
                    <span style="font-weight:bold">PHONE NO:</span> <?php echo e($cd['phone_no']); ?> <br>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <br>
                    <span style="font-weight:bold">LOAN TENURE:</span> 
                   <?php if($tenure == null): ?>
                     <span style="color:orange">No tenure selected for this purchase...</span>
                   <?php else: ?>
                    <?php echo e($tenure); ?> Months <br>
                   <?php endif; ?>
                </p>
            </div>
         </div>
         
        <br>
        
        <table class="inventory">
            <thead>
                <tr>
                    <th>Order No</th>
                    <th width="45%">Product</th>
                    <th width="5%">Qty</th>
                    <th>Sub Total</th>
                </tr>
            </thead>
            <tbody>
				<?php $__currentLoopData = $orders['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($order['order_id']); ?></td>
                    <td><?php echo e($order['products_ordered']); ?></td>
                    <td><?php echo e($order['quantity']); ?></td>
                    <td>
						<?php
						  $qty = $order['quantity'];
						  $price = $order['unit_price'];
						  $subtotal = $qty * $price;
						  echo $st = '&#x20A6;'.number_format($subtotal,2);
						?>
					</td>
                </tr>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <!--<a class="add"> Add +</a>-->
        <table class="balance">
			<?php $__currentLoopData = $oudatas['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $oudata): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<tr>
					<th>TOTAL</th>
					<td><span>&#x20A6;<?php echo e(number_format($oudata['total'],2)); ?></span> </td>
				</tr>
				<tr>
					<th>Shipping fee</th>
					<td><span>&#x20A6;<?php echo e(number_format($oudata['pickup']*$oudata['total'],2)); ?></span></td>
				</tr>
				<tr>
					<th>SUB TOTAL</th>
					<td><span>&#x20A6;<?php echo e(number_format($oudata['ototal'],2)); ?></span></td>
				</tr>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </table>

    <div class="footer">
        <h1>Amaecom Ecommerce Invoice</h1>
        <div style="text-align:center">
            (C) Amaecom Global
            <br>
        </div>
    </div>

   </div>

    <script src="<?php echo e(asset('/ivassets/js/main.min.js')); ?>"></script>
</body>

</html>
<?php /**PATH /home/beefbigb/public_html/resources/views/invoice.blade.php ENDPATH**/ ?>