<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/apply', 'App\Http\Controllers\IndexController@index');
Route::get('/apply2', 'App\Http\Controllers\IndexMController@index');
Route::get('/paycashm/{pn}', 'App\Http\Controllers\IndexController@paycash');
Route::get('/paramm', 'App\Http\Controllers\IndexController@debitcustomer');
Route::get('/test', 'App\Http\Controllers\IndexController@test');
Route::get('/user-login', 'App\Http\Controllers\IndexController@ulogin');
Route::get('/user-login2', 'App\Http\Controllers\IndexMController@ulogin');
Route::get('/resend-verify', 'App\Http\Controllers\RegisterController@resendV');
Route::get('/admin-login', 'App\Http\Controllers\IndexController@slogin');
Route::post('/send-pass-reset', 'App\Http\Controllers\IndexController@sendpassreset');
Route::post('/send-pass-reset2', 'App\Http\Controllers\IndexController@sendpassreset2');
Route::get('/reset-password/{id}', 'App\Http\Controllers\IndexController@resetpass');
Route::post('/update-password', 'App\Http\Controllers\IndexController@updatepass');
Route::post('/create-user', 'App\Http\Controllers\RegisterController@regUser');
Route::post('/create-user2', 'App\Http\Controllers\RegisterMController@regUser');
Route::post('/auth-user', 'App\Http\Controllers\LoginController@authUser');
Route::post('/auth-user2', 'App\Http\Controllers\LoginMController@authUser');
Route::post('/auth-admin', 'App\Http\Controllers\LoginController@authadmin');
Route::get('/verify/{em}', 'App\Http\Controllers\RegisterController@verify');
Route::post('/debnotification', 'App\Http\Controllers\IndexController@notification');



//MRest Routes
Route::get('/get-user/{em}', 'App\Http\Controllers\MRestController@getUser');
Route::get('/repayments/{pn}', 'App\Http\Controllers\MRestController@repaymenthistory');
Route::post('/update-detailsm', 'App\Http\Controllers\MRestController@updatedetails'); 
Route::post('/update-avatar', 'App\Http\Controllers\MRestController@updateavatar'); 
 
 
 

// User Dashboard
Route::group(['middleware' => ['customauth']], function(){ 
		  	Route::get('/userdashboard', 'App\Http\Controllers\UserController@userdashboard');
		  	Route::get('/my-loans', 'App\Http\Controllers\UserController@myloans');
		  	Route::post('/new-loan', 'App\Http\Controllers\UserController@newloan');
		  	Route::post('/uploadphoto', 'App\Http\Controllers\UserController@uploadphoto');
		  	Route::any('/paycash', 'App\Http\Controllers\UserController@paycash');
		  	Route::get('/param', 'App\Http\Controllers\UserController@debitcustomer');
		  	Route::get('/repayment-breakdown', 'App\Http\Controllers\UserController@repayments');
		  	Route::get('/my-repayments', 'App\Http\Controllers\UserController@repaymenthistory');
		  	Route::get('/transaction-history', 'App\Http\Controllers\UserController@tranxhist');
		  	Route::get('/user-logout', 'App\Http\Controllers\UserController@userlogout');
		    Route::post('/updatephoto', 'App\Http\Controllers\UserController@updatephoto');
		    Route::post('/update-details', 'App\Http\Controllers\UserController@updatedetails');
	    });
	    

Route::group(['middleware' => ['customauth2']], function(){ 
		  	Route::get('/userdashboard', 'App\Http\Controllers\UserMController@userdashboard');
		  	Route::get('/my-loans', 'App\Http\Controllers\UserMController@myloans');
		  	Route::post('/new-loan', 'App\Http\Controllers\UserMController@newloan');
		  	Route::post('/uploadphoto', 'App\Http\Controllers\UserMController@uploadphoto');
		  	Route::any('/paycash', 'App\Http\Controllers\UserMController@paycash');
		  	Route::get('/param', 'App\Http\Controllers\UserMController@debitcustomer');
		  	Route::get('/repayment-breakdown', 'App\Http\Controllers\UserMController@repayments');
		  	Route::get('/my-repayments', 'App\Http\Controllers\UserMController@repaymenthistory');
		  	Route::get('/transaction-history', 'App\Http\Controllers\UserMController@tranxhist');
		  	Route::get('/user-logout', 'App\Http\Controllers\UserMController@userlogout');
		     Route::post('/updatephoto', 'App\Http\Controllers\UserMController@updatephoto');
		    Route::post('/update-details', 'App\Http\Controllers\UserMController@updatedetails');
	    });	    
	    

// Admin
// Admin Dashboard
	    Route::group(['middleware' => ['customauth3']], function(){ 
		  	Route::get('/admindashboard', 'App\Http\Controllers\AdminController@admindashboard');
		  	
		  	Route::get('/admin/loan-applicants', 'App\Http\Controllers\AdminController@applicants');
		  	Route::get('/admin/registered-users', 'App\Http\Controllers\AdminController@regusers');
		  	Route::post('/search-applicant', 'App\Http\Controllers\AdminController@searchapplicant');
		  	Route::post('/search-applicant2', 'App\Http\Controllers\AdminController@searchapplicant2');
		  	Route::post('/search-users', 'App\Http\Controllers\AdminController@searchusers');
		    Route::get('/admin/approved-list', 'App\Http\Controllers\AdminController@approvedlist');
		    Route::get('/admin/declined-list', 'App\Http\Controllers\AdminController@declinedlist');
		    Route::get('/admin/disbursed-list', 'App\Http\Controllers\AdminController@disbursedlist');
		    Route::get('/debit-transactions', 'App\Http\Controllers\AdminController@debittransactions');
		    Route::get('/customer-rrrs', 'App\Http\Controllers\AdminController@custrrrs');
		    Route::get('/debit-mandate-status/{ms}', 'App\Http\Controllers\AdminController@mandateStatus');
		    Route::get('/operations/{pn}', 'App\Http\Controllers\AdminController@operations');
		    Route::get('/salaryhistory/{pn}', 'App\Http\Controllers\AdminController@bhist');
		    Route::get('/loanhistory/{pn}', 'App\Http\Controllers\AdminController@lhist');
		    Route::get('/loanhistory/{pn}', 'App\Http\Controllers\AdminController@lhist');
		    Route::get('/stopmandate/{pn}', 'App\Http\Controllers\AdminController@stopmandate');
		    Route::get('/stopped-mandate-list', 'App\Http\Controllers\AdminController@stopmandatelist');
		    Route::get('/authorisation/{pn}', 'App\Http\Controllers\AdminController@authorisation');
		    Route::get('/approve/{pn}', 'App\Http\Controllers\AdminController@approve');
		    Route::get('/decline/{pn}', 'App\Http\Controllers\AdminController@decline');
		    Route::get('/disburse/{pn}', 'App\Http\Controllers\AdminController@disbursepa');
		    Route::get('/debit-user/{pn}', 'App\Http\Controllers\AdminController@debituser');
		    Route::get('/send-funds/{pn}/{amt}', 'App\Http\Controllers\AdminController@debituser');
		    Route::get('/mark-as-paid/{pn}', 'App\Http\Controllers\AdminController@map');
		    Route::get('/remitta-outgoing-payments', 'App\Http\Controllers\AdminController@remoutgoing');
		    Route::get('/debit-notification-log', 'App\Http\Controllers\AdminController@debnotilog');
		    Route::get('/authorization/{pn}', 'App\Http\Controllers\AdminController@authorisation');
		    Route::get('/repayment-history/{pn}', 'App\Http\Controllers\AdminController@repaymentHistory');
		    Route::get('/view-applicant-info/{pn}', 'App\Http\Controllers\AdminController@viewcust');
		    Route::post('/create-admin',    'App\Http\Controllers\AdminController@createadmin');
		    Route::get('/manage-admins', 'App\Http\Controllers\AdminController@manageadmin');
		    Route::get('/user-activities', 'App\Http\Controllers\AdminController@uactivities');
		    Route::any('/update-admin', 'App\Http\Controllers\AdminController@updateadmin');
		    Route::get('/delete-admin/{id}', 'App\Http\Controllers\AdminController@deleteadmin');
		    Route::any('/update-interest', 'App\Http\Controllers\AdminController@updateinterest');
		    
		    Route::get('/update-loanamt/{pn}', 'App\Http\Controllers\AdminController@updateloanamt');
		    
		    Route::any('/updateloanamt', 'App\Http\Controllers\AdminController@updateloanamt2');
		    Route::get('/create-ads', 'App\Http\Controllers\AdminController@createads');
		    Route::post('/uploadad', 'App\Http\Controllers\AdminController@uploadad');
		    
		    Route::post('/updatead', 'App\Http\Controllers\AdminController@updatead');
		    
		    Route::get('/admin-logout', 'App\Http\Controllers\AdminController@adminlogout');
		   
		    
	    });

