/* =========================================================
 * bootstrap-colorpicker.js
 * http://www.eyecon.ro/bootstrap-colorpicker
 * =========================================================
 * Copyright 2012 Stefan Petre
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ========================================================= */
! function(d) {
    var e = function(f) {
        this.value = {
            h: 1,
            s: 1,
            b: 1,
            a: 1
        };
        this.setColor(f)
    };
    e.prototype = {
        constructor: e,
        setColor: function(g) {
            g = g.toLowerCase();
            var f = this;
            d.each(c.stringParsers, function(k, m) {
                var j = m.re.exec(g),
                    h = j && m.parse(j),
                    l = m.space || "rgba";
                if (h) {
                    if (l === "hsla") {
                        f.value = c.RGBtoHSB.apply(null, c.HSLtoRGB.apply(null, h))
                    } else {
                        f.value = c.RGBtoHSB.apply(null, h)
                    }
                    return false
                }
                return true
            })
        },
        setHue: function(f) {
            this.value.h = 1 - f
        },
        setSaturation: function(f) {
            this.value.s = f
        },
        setLightness: function(f) {
            this.value.b = 1 - f
        },
        setAlpha: function(f) {
            this.value.a = parseInt((1 - f) * 100, 10) / 100
        },
        toRGB: function(k, o, l, m) {
            if (!k) {
                k = this.value.h;
                o = this.value.s;
                l = this.value.b
            }
            k *= 360;
            var j, n, g, i, f;
            k = (k % 360) / 60;
            f = l * o;
            i = f * (1 - Math.abs(k % 2 - 1));
            j = n = g = l - f;
            k = ~~k;
            j += [f, i, 0, 0, i, f][k];
            n += [i, f, f, i, 0, 0][k];
            g += [0, 0, i, f, f, i][k];
            return {
                r: Math.round(j * 255),
                g: Math.round(n * 255),
                b: Math.round(g * 255),
                a: m || this.value.a
            }
        },
        toHex: function(k, j, f, g) {
            var i = this.toRGB(k, j, f, g);
            return "#" + ((1 << 24) | (parseInt(i.r) << 16) | (parseInt(i.g) << 8) | parseInt(i.b)).toString(16).substr(1)
        },
        toHSL: function(m, l, g, i) {
            if (!m) {
                m = this.value.h;
                l = this.value.s;
                g = this.value.b
            }
            var k = m,
                f = (2 - l) * g,
                j = l * g;
            if (f > 0 && f <= 1) {
                j /= f
            } else {
                j /= 2 - f
            }
            f /= 2;
            if (j > 1) {
                j = 1
            }
            return {
                h: k,
                s: j,
                l: f,
                a: i || this.value.a
            }
        }
    };
    var a = 0;
    var b = function(g, f) {
        a++;
        this.element = d(g).attr("data-colorpicker-guid", a);
        var h = f.format || this.element.data("color-format") || "hex";
        this.format = c.translateFormats[h];
        this.isInput = this.element.is("input");
        this.component = this.element.is(".color") ? this.element.find(".input-group-addon") : false;
        this.picker = d(c.template).attr("data-colorpicker-guid", a).appendTo("body").on("mousedown.colorpicker", d.proxy(this.mousedown, this));
        if (this.isInput) {
            this.element.on({
                "focus.colorpicker": d.proxy(this.show, this),
                "keyup.colorpicker": d.proxy(this.update, this)
            })
        } else {
            if (this.component) {
                this.component.on({
                    "click.colorpicker": d.proxy(this.show, this)
                })
            } else {
                this.element.on({
                    "click.colorpicker": d.proxy(this.show, this)
                })
            }
        }
        if (h === "rgba" || h === "hsla") {
            this.picker.addClass("alpha");
            this.alpha = this.picker.find(".colorpicker-alpha")[0].style
        }
        if (this.component) {
            this.picker.find(".colorpicker-color").hide();
            this.preview = this.element.find("i")[0].style
        } else {
            this.preview = this.picker.find("div:last")[0].style
        }
        this.base = this.picker.find("div:first")[0].style;
        this.update();
        d(d.proxy(function() {
            this.element.trigger("create", [this])
        }, this))
    };
    b.prototype = {
        constructor: b,
        show: function(f) {
            this.picker.show();
            this.height = this.component ? this.component.outerHeight() : this.element.outerHeight();
            this.place();
            d(window).on("resize.colorpicker", d.proxy(this.place, this));
            if (!this.isInput) {
                if (f) {
                    f.stopPropagation();
                    f.preventDefault()
                }
            }
            d(document).on({
                "mousedown.colorpicker": d.proxy(this.hide, this)
            });
            this.element.trigger({
                type: "showPicker",
                color: this.color
            })
        },
        update: function() {
            var f = this.isInput ? this.element.prop("value") : this.element.data("color");
            if (typeof f === "undefined" || f === null) {
                f = "#ffffff"
            }
            this.color = new e(f);
            this.picker.find("i").eq(0).css({
                left: this.color.value.s * 100,
                top: 100 - this.color.value.b * 100
            }).end().eq(1).css("top", 100 * (1 - this.color.value.h)).end().eq(2).css("top", 100 * (1 - this.color.value.a));
            this.previewColor()
        },
        hide: function() {
            this.picker.hide();
            d(window).off("resize", this.place);
            d(document).off({
                mousedown: this.hide
            });
            if (!this.isInput) {
                if (this.component) {
                    if (this.element.find("input").val() !== "") {
                        this.element.find("input").prop("value", this.format.call(this)).trigger("change")
                    }
                }
                this.element.data("color", this.format.call(this))
            } else {
                if (this.element.val() !== "") {
                    this.element.prop("value", this.format.call(this)).trigger("change")
                }
            }
            this.element.trigger({
                type: "hidePicker",
                color: this.color
            })
        },
        place: function() {
            var f = this.component ? this.component.offset() : this.element.offset();
            this.picker.css({
                top: f.top + this.height,
                left: f.left
            })
        },
        destroy: function() {
            d(".colorpicker[data-colorpicker-guid=" + this.element.attr("data-colorpicker-guid") + "]").remove();
            this.element.removeData("colorpicker").removeAttr("data-colorpicker-guid").off(".colorpicker");
            if (this.component !== false) {
                this.component.off(".colorpicker")
            }
            this.element.trigger("destroy", [this])
        },
        setValue: function(f) {
            if (this.isInput) {
                this.element.prop("value", f)
            } else {
                this.element.find("input").val(f);
                this.element.data("color", f)
            }
            this.update();
            this.element.trigger({
                type: "changeColor",
                color: this.color
            })
        },
        previewColor: function() {
            try {
                this.preview.backgroundColor = this.format.call(this)
            } catch (f) {
                this.preview.backgroundColor = this.color.toHex()
            }
            this.base.backgroundColor = this.color.toHex(this.color.value.h, 1, 1, 1);
            if (this.alpha) {
                this.alpha.backgroundColor = this.color.toHex()
            }
        },
        pointer: null,
        slider: null,
        mousedown: function(h) {
            h.stopPropagation();
            h.preventDefault();
            var g = d(h.target);
            var f = g.closest("div");
            if (!f.is(".colorpicker")) {
                if (f.is(".colorpicker-saturation")) {
                    this.slider = d.extend({}, c.sliders.saturation)
                } else {
                    if (f.is(".colorpicker-hue")) {
                        this.slider = d.extend({}, c.sliders.hue)
                    } else {
                        if (f.is(".colorpicker-alpha")) {
                            this.slider = d.extend({}, c.sliders.alpha)
                        } else {
                            return false
                        }
                    }
                }
                var i = f.offset();
                this.slider.knob = f.find("i")[0].style;
                this.slider.left = h.pageX - i.left;
                this.slider.top = h.pageY - i.top;
                this.pointer = {
                    left: h.pageX,
                    top: h.pageY
                };
                d(document).on({
                    "mousemove.colorpicker": d.proxy(this.mousemove, this),
                    "mouseup.colorpicker": d.proxy(this.mouseup, this)
                }).trigger("mousemove")
            }
            return false
        },
        mousemove: function(h) {
            h.stopPropagation();
            h.preventDefault();
            var g = Math.max(0, Math.min(this.slider.maxLeft, this.slider.left + ((h.pageX || this.pointer.left) - this.pointer.left)));
            var f = Math.max(0, Math.min(this.slider.maxTop, this.slider.top + ((h.pageY || this.pointer.top) - this.pointer.top)));
            this.slider.knob.left = g + "px";
            this.slider.knob.top = f + "px";
            if (this.slider.callLeft) {
                this.color[this.slider.callLeft].call(this.color, g / 100)
            }
            if (this.slider.callTop) {
                this.color[this.slider.callTop].call(this.color, f / 100)
            }
            this.previewColor();
            if (!this.isInput) {
                try {
                    this.element.find("input").val(this.format.call(this)).trigger("change")
                } catch (h) {
                    this.element.find("input").val(this.color.toHex()).trigger("change")
                }
            } else {
                try {
                    this.element.val(this.format.call(this)).trigger("change")
                } catch (h) {
                    this.element.val(this.color.toHex()).trigger("change")
                }
            }
            this.element.trigger({
                type: "changeColor",
                color: this.color
            });
            return false
        },
        mouseup: function(f) {
            f.stopPropagation();
            f.preventDefault();
            d(document).off({
                mousemove: this.mousemove,
                mouseup: this.mouseup
            });
            return false
        }
    };
    d.fn.colorpicker = function(f, g) {
        return this.each(function() {
            var j = d(this),
                i = j.data("colorpicker"),
                h = typeof f === "object" && f;
            if (!i) {
                if (f !== "destroy") {
                    j.data("colorpicker", (i = new b(this, d.extend({}, d.fn.colorpicker.defaults, h))))
                }
            } else {
                if (typeof f === "string") {
                    i[f](g)
                }
            }
        })
    };
    d.fn.colorpicker.defaults = {};
    d.fn.colorpicker.Constructor = b;
    var c = {
        translateFormats: {
            rgb: function() {
                var f = this.color.toRGB();
                return "rgb(" + f.r + "," + f.g + "," + f.b + ")"
            },
            rgba: function() {
                var f = this.color.toRGB();
                return "rgba(" + f.r + "," + f.g + "," + f.b + "," + f.a + ")"
            },
            hsl: function() {
                var f = this.color.toHSL();
                return "hsl(" + Math.round(f.h * 360) + "," + Math.round(f.s * 100) + "%," + Math.round(f.l * 100) + "%)"
            },
            hsla: function() {
                var f = this.color.toHSL();
                return "hsla(" + Math.round(f.h * 360) + "," + Math.round(f.s * 100) + "%," + Math.round(f.l * 100) + "%," + f.a + ")"
            },
            hex: function() {
                return this.color.toHex()
            }
        },
        sliders: {
            saturation: {
                maxLeft: 100,
                maxTop: 100,
                callLeft: "setSaturation",
                callTop: "setLightness"
            },
            hue: {
                maxLeft: 0,
                maxTop: 100,
                callLeft: false,
                callTop: "setHue"
            },
            alpha: {
                maxLeft: 0,
                maxTop: 100,
                callLeft: false,
                callTop: "setAlpha"
            }
        },
        RGBtoHSB: function(m, l, f, i) {
            m /= 255;
            l /= 255;
            f /= 255;
            var k, j, h, n;
            h = Math.max(m, l, f);
            n = h - Math.min(m, l, f);
            k = (n === 0 ? null : h === m ? (l - f) / n : h === l ? (f - m) / n + 2 : (m - l) / n + 4);
            k = ((k + 360) % 6) * 60 / 360;
            j = n === 0 ? 0 : n / h;
            return {
                h: k || 1,
                s: j,
                b: h,
                a: i || 1
            }
        },
        HueToRGB: function(i, g, f) {
            if (f < 0) {
                f += 1
            } else {
                if (f > 1) {
                    f -= 1
                }
            }
            if ((f * 6) < 1) {
                return i + (g - i) * f * 6
            } else {
                if ((f * 2) < 1) {
                    return g
                } else {
                    if ((f * 3) < 2) {
                        return i + (g - i) * ((2 / 3) - f) * 6
                    } else {
                        return i
                    }
                }
            }
        },
        HSLtoRGB: function(o, x, m, w) {
            if (x < 0) {
                x = 0
            }
            var i;
            if (m <= 0.5) {
                i = m * (1 + x)
            } else {
                i = m + x - (m * x)
            }
            var j = 2 * m - i;
            var u = o + (1 / 3);
            var k = o;
            var n = o - (1 / 3);
            var f = Math.round(c.HueToRGB(j, i, u) * 255);
            var t = Math.round(c.HueToRGB(j, i, k) * 255);
            var v = Math.round(c.HueToRGB(j, i, n) * 255);
            return [f, t, v, w || 1]
        },
        stringParsers: [{
            re: /rgba?\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,
            parse: function(f) {
                return [f[1], f[2], f[3], f[4]]
            }
        }, {
            re: /rgba?\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,
            parse: function(f) {
                return [2.55 * f[1], 2.55 * f[2], 2.55 * f[3], f[4]]
            }
        }, {
            re: /#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/,
            parse: function(f) {
                return [parseInt(f[1], 16), parseInt(f[2], 16), parseInt(f[3], 16)]
            }
        }, {
            re: /#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/,
            parse: function(f) {
                return [parseInt(f[1] + f[1], 16), parseInt(f[2] + f[2], 16), parseInt(f[3] + f[3], 16)]
            }
        }, {
            re: /hsla?\(\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,
            space: "hsla",
            parse: function(f) {
                return [f[1] / 360, f[2] / 100, f[3] / 100, f[4]]
            }
        }],
        template: '<div class="colorpicker dropdown-menu"><div class="colorpicker-saturation"><i><b></b></i></div><div class="colorpicker-hue"><i></i></div><div class="colorpicker-alpha"><i></i></div><div class="colorpicker-color"><div /></div></div>'
    }
}(window.jQuery);