<!DOCTYPE html>
<html class="wide wow-animation" lang="en">
  <head>
    <title>Fullrange MFB - Loan Application</title></title>
    <meta name="viewport" content="width=device-width height=device-height initial-scale=1.0">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <link rel="icon" href="images/favicon.png" type="image/x-icon">
   <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Noto+Sans:wght@900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/fonts.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/pc.css')); ?>">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.3/jquery.min.js" integrity="sha512-STof4xm1wgkfm7heWqFJVn58Hm3EtS31XFaagaa8VMReCXAkQnJZ+jEy8PCC/iT18dFy95WcExNHFTqLyp72eQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.1/dist/sweetalert2.all.min.js"></script>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/pcsweetalert.css')); ?>">
    <script src="<?php echo e(asset('assets/js/pc.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pc-icons.min.js')); ?>"></script>
    
    <style>
        

/* CSS */
.button-34 {
  background: #3b6bb2;
  border-radius: 50px;
  box-shadow: #5E5DF0 0 10px 20px -10px;
  box-sizing: border-box;
  color: #FFFFFF;
  cursor: pointer;
  font-family: Inter,Helvetica,"Apple Color Emoji","Segoe UI Emoji",NotoColorEmoji,"Noto Color Emoji","Segoe UI Symbol","Android Emoji",EmojiSymbols,-apple-system,system-ui,"Segoe UI",Roboto,"Helvetica Neue","Noto Sans",sans-serif;
  font-size: 16px;
  font-weight: 700;
  line-height: 24px;
  opacity: 1;
  outline: 0 solid transparent;
  padding: 8px 18px;
  user-select: none;
  -webkit-user-select: none;
  touch-action: manipulation;
  width: fit-content;
  word-break: break-word;
  border: 0;
}

#overlay {
  position: fixed;
  display: none;
  width: 100%;
  height: 100%;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: rgba(0,0,0,0.5);
  z-index: 2;
  cursor: pointer;
}
    </style>
  </head>
  
  
  <body  style="background: linear-gradient(0deg, rgba(59 107 178 / 54%), rgba(59 107 178 / 69%)), url(<?php echo e(asset('assets/images/bgimg.jpg')); ?>); height: 100%;background-position: center;background-repeat: no-repeat;background-size: cover;">
      <div id="overlay" onclick="off()">
          
          <h3 class="uk-position-center uk-text-bolder" style="color:white">Please wait...</h3>
          </div>
      <div class="uk-container">
          <br> <br> <br> <br> <br>
          <div>
        <div class="uk-card uk-card-default uk-card-hover uk-card-body" style="border-radius:15px">
              <div style="padding:15px">
                       <img src="https://fullrangemfb.com/frwapp/adminassets/assets/images/logo.png" alt="login-icon" style="max-width:100px">
                  </div>
            <h1 class="uk-card-title uk-text-lead uk-text-bolder uk-text-center"
             style="color:#3b3e7f;font-family: 'Noto Sans', sans-serif;">Fullpay Loan Application Form</h1>
            <hr>
            <div>
                 <nav aria-label="Breadcrumb">
    <ul class="uk-breadcrumb">
        <li><a href="https://fullrangemfb">Home</a></li>
        <li class="uk-disabled"><a>Loan Application</a></li>
    </ul>
</nav>
    <br>
                
       
<div uk-switcher="animation: uk-animation-fade; toggle: > *">
    <button class="uk-button uk-button-default" style="border-radius:15px" type="button"><span class="uk-badge">1</span> Get Started</button>
    <button class="uk-button uk-button-default" style="border-radius:15px" type="button"><span class="uk-badge">2</span> Personal Information</button>
    <button class="uk-button uk-button-default" style="border-radius:15px" type="button"><span class="uk-badge">3</span> Bio Data</button>
    <button class="uk-button uk-button-default" style="border-radius:15px" type="button"><span class="uk-badge">4</span> Employment Details</button>
    <button class="uk-button uk-button-default" style="border-radius:15px" type="button"><span class="uk-badge">5</span> Loan</button>
</div>

<ul class="uk-switcher uk-margin">
     <li>
         <form method="post" action="https://fullrangemfb.com/frwapp/create-user">
            <?php echo csrf_field(); ?>
            <h3 class="uk-card-title uk-text-lead uk-text-bolder uk-text-center"
             style="color:#3b3e7f">Let's get you started</h3>
             <small class="uk-align-center" align="center">Provide the information below</small>
            <fieldset class="uk-fieldset">

              <legend class="uk-legend">Get Started</legend>
              
               
                
                <div class="uk-form-horizontal uk-margin-small">

                  <div class="uk-margin-small">
                     <label class="uk-form-label" for="form-horizontal-text">Email Address</label>
                     <div class="uk-form-controls">
                       <input class="uk-input" type="email" id="email" name="email" placeholder="Entet E-mail Address" aria-label="Input" style="width:200px;height:45px;border-radius:5px">
                     </div>
                   </div>
                   
                   <div class="uk-margin">
                     <label class="uk-form-label" for="form-horizontal-text">Phone No</label>
                     <div class="uk-form-controls">
                        <input class="uk-input" type="tel" maxlength="11" onkeyup="this.value=this.value.replace(/[^\d]/,'')" name="phoneno" placeholder="Provide Phone No" id="phoneno" style="border-radius:5px;width:200px;height:45px">
                     </div>
                   </div>
                </div>
                
                
                
                <br><br>
                 <a href="#" uk-switcher-item="next" class="button-34 uk-align-left">Proceed <span uk-icon="icon: arrow-right"></span></a>
            </fieldset>
      </li>
      <li>
          <h3 class="uk-card-title uk-text-lead uk-text-bolder uk-text-center"
             style="color:#3b3e7f">Personal Information</h3>
             <small class="uk-align-center" align="center">Provide the information below</small>
           <fieldset class="uk-fieldset">

              <legend class="uk-legend">Personal Information</legend>
          <div class="uk-grid-small" uk-grid>
              <div class="uk-width-1-2@s">
                  <label>Firstname</label>
                  <input class="uk-input" type="text" id="fn" name="fn" placeholder="Enter Firstname" aria-label="Input" style="border-radius:5px">
              </div>
              <div class="uk-width-1-2@s">
                   <label>Surname</label>
                 <input class="uk-input" type="text" id="ln" name="ln" placeholder="Enter Surname" aria-label="Input" style="border-radius:5px">
              </div>
              
              <br>
              
              <div class="uk-width-1-2@s">
                   <label>Password</label>
                  <input class="uk-input" type="password" id="password" name="password" placeholder="Enter Password"  style="border-radius:5px">
              </div>
              <div class="uk-width-1-2@s">
                   <label>Confirm Password</label>
                 <input class="uk-input" type="password" id="cpassword" name="cpassword" placeholder="Re-Enter Password" onkeyup="mpass();" style="border-radius:5px">
            <span id="msg"></span>
              </div>
              
              <br>
              <div class="uk-width-1-2@s">
                  <label>Address</label>
                   <textarea class="uk-textarea" rows="5" placeholder="Enter Address" id="address" name="address" aria-label="Textarea" style="border-radius:5px"></textarea>
              </div>
              <div class="uk-width-1-2@s">
                   <label>Next Of Kin</label>
                  <input class="uk-input" type="text" id="nok" name="nok" placeholder="Next Of Kin" aria-label="Input" style="border-radius:5px">
              </div>
              
               <br>
              <div class="uk-width-1-2@s">
                  <label>Relationship Of Next Of Kin</label>
                   <select class="uk-select" aria-label="Select" id="nor" name="nor" style="border-radius:5px">
                <option disabled selected>Select Relationship Of Next Of Kin</option>
                <option value="Brother">Brother</option>
                <option value="Sister">Sister</option>
                <option value="Cousin">Cousin</option>
                <option value="Nephew">Nephew</option>
                <option value="Spouse">Spouse</option>
                <option value="Other">Other</option>
            </select>
              </div>
              <div class="uk-width-1-2@s">
                   <label>Next Of Kin Phone no</label>
                   <input class="uk-input" type="tel" maxlength="11" onkeyup="this.value=this.value.replace(/[^\d]/,'')" name="nokphoneno" placeholder="Enter Next Of Kin Phone Number" id="nokphoneno" style="border-radius:5px">
              </div>
              
               <br>
              <div class="uk-width-1-2@s">
                  <label>Next Of Kin Address</label>
                  <textarea class="uk-textarea" rows="5" placeholder="Enter Next Of Kin Address" id="nokaddress" name="nokaddress" aria-label="Textarea" style="border-radius:5px"></textarea>
              </div>
              <div class="uk-width-1-2@s">
                   <label>Next Of Kin State</label>
                   <select class="uk-select" aria-label="Select" id="nokstate" name="nokstate" style="border-radius:5px">
                <option disabled selected>Next Of Kin State </option>
    <option value="Abia">Abia</option>
    <option value="Adamawa">Adamawa</option>
    <option value="Akwa Ibom">Akwa Ibom</option>
    <option value="Anambra">Anambra</option>
    <option value="Bauchi">Bauchi</option>
    <option value="Bayelsa">Bayelsa</option>
    <option value="Benue">Benue</option>
    <option value="Borno">Borno</option>
    <option value="Cross River">Cross River</option>
    <option value="Delta">Delta</option>
    <option value="Ebonyi">Ebonyi</option>
    <option value="Edo">Edo</option>
    <option value="Ekiti">Ekiti</option>
    <option value="Enugu">Enugu</option>
    <option value="FCT">Federal Capital Territory</option>
    <option value="Gombe">Gombe</option>
    <option value="Imo">Imo</option>
    <option value="Jigawa">Jigawa</option>
    <option value="Kaduna">Kaduna</option>
    <option value="Kano">Kano</option>
    <option value="Katsina">Katsina</option>
    <option value="Kebbi">Kebbi</option>
    <option value="Kogi">Kogi</option>
    <option value="Kwara">Kwara</option>
    <option value="Lagos">Lagos</option>
    <option value="Nasarawa">Nasarawa</option>
    <option value="Niger">Niger</option>
    <option value="Ogun">Ogun</option>
    <option value="Ondo">Ondo</option>
    <option value="Osun">Osun</option>
    <option value="Oyo">Oyo</option>
    <option value="Plateau">Plateau</option>
    <option value="Rivers">Rivers</option>
    <option value="Sokoto">Sokoto</option>
    <option value="Taraba">Taraba</option>
    <option value="Yobe">Yobe</option>
    <option value="Zamfara">Zamfara</option>
            </select>
              </div>
              
              
          </div>
          
          <br><br>
         <a href="#" uk-switcher-item="previous" class="button-34"><span uk-icon="icon: arrow-left"></span> Previous</a>
         <a href="#" uk-switcher-item="next" class="button-34 uk-align-right">Proceed <span uk-icon="icon: arrow-right"></span></a>
          </fieldset>
      </li>
      <li>
           <h3 class="uk-card-title uk-text-lead uk-text-bolder uk-text-center"
             style="color:#3b3e7f">Bio Data Information</h3>
             <small class="uk-align-center" align="center">Provide the information below</small>
            <fieldset class="uk-fieldset">

              <legend class="uk-legend">Bio Data</legend>
          <div class="uk-grid-small" uk-grid>
              <div class="uk-width-1-2@s">
                  <label>BVN</label>
                   <input class="uk-input" type="tel" id="bvn" name="bvn" maxlength="11" placeholder="Enter BVN" onkeyup="this.value=this.value.replace(/[^\d]/,'')" aria-label="Input" style="border-radius:5px">
              </div>
              <div class="uk-width-1-2@s">
                   <label>NIN</label>
                  <input class="uk-input" type="tel" id="nin" name="nin" placeholder="Enter NIN" onkeyup="this.value=this.value.replace(/[^\d]/,'')" aria-label="Input" style="border-radius:5px">
              </div>
              
              <br>
              <div class="uk-width-1-2@s">
                  <label>Date Of Birth</label>
                   <input class="uk-input" type="text" id="dob" name="dob" placeholder="Date Of Birth" aria-label="Input"  onclick="(this.type='date')" style="border-radius:5px">
              </div>
              <div class="uk-width-1-2@s">
                   <label>Gender</label>
                   <select class="uk-select" aria-label="Select" id="gender" name="gender">
                <option disabled selected>Select Gender</option>
                <option value="1">Male</option>
                <option value="0">Female</option>
            </select>
              </div>
              
              <br>
              <div class="uk-width-1-2@s">
                  <label>Bank</label>
    
                  <select class="uk-select" aria-label="Select" id="bname" name="bname" style="border-radius:5px">
                <option disabled selected>Select Bank</option>
                   <?php $__currentLoopData = $banks["data"]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <option value="<?php echo e($bank['name']); ?>,<?php echo e($bank['code']); ?>"><?php echo e($bank['name']); ?></option>
                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
               
              </div>
              <div class="uk-width-1-2@s">
                   <label>Account No</label>
                  <input class="uk-input" type="tel" onkeyup="this.value=this.value.replace(/[^\d]/,'')" name="acctno" placeholder="Account Number" id="acctno" style="border-radius:5px">
              </div>
           </div>
          <br><br>
         <a href="#" uk-switcher-item="previous" class="button-34"><span uk-icon="icon: arrow-left"></span> Previous</a>
         <a href="#" uk-switcher-item="next" class="button-34 uk-align-right">Proceed <span uk-icon="icon: arrow-right"></span></a>
         </fieldset>
      </li>
      
      <li>
          <h3 class="uk-card-title uk-text-lead uk-text-bolder uk-text-center"
             style="color:#3b3e7f">Employment Details</h3>
             <small class="uk-align-center" align="center">Provide the information below</small>
            <fieldset class="uk-fieldset">

              <legend class="uk-legend">Employment Info</legend>
       
               <div class="uk-form-horizontal uk-margin-large">

                  <div class="uk-margin">
                     <label class="uk-form-label" for="form-horizontal-text">Employment Status</label>
                     <div class="uk-form-controls">
                       <select class="uk-select" aria-label="Select" id="estatus" name="estatus" style="border-radius:5px;width:200px;height:45px">
                <option disabled selected>Select Employment Status</option>
                <option value="Employed">Employed</option>
                <option value="Self Employed">Self Employed</option>
                <option value="UnEmployed">UnEmployed</option>
            </select>
                     </div>
                   </div>
                   
                   <div class="uk-margin">
                     <label class="uk-form-label" for="form-horizontal-text">MDA</label>
                     <div class="uk-form-controls">
                        <select class="uk-select" aria-label="Select" id="mda" name="mda" style="width:200px;height:45px">
                <option disabled selected>Select MDA</option>
                <option value="Federal Inland Revenue Service">Federal Inland Revenue Service</option>
  <option value="ABUBAKAR TAFAWA BALEWA UNIVERSITY TEACHING HOSPITAL">ABUBAKAR TAFAWA BALEWA UNIVERSITY TEACHING HOSPITAL</option>
<option value="AFRICAN REGIONAL CENTRE FOR SPACE SCIENCE AND TECHED">AFRICAN REGIONAL CENTRE FOR SPACE SCIENCE AND TECHED</option>
<option value="AGRICULTURAL AND RURAL MANAGEMENT TRAINING INSTITUTE ILORIN">AGRICULTURAL AND RURAL MANAGEMENT TRAINING INSTITUTE ILORIN</option>
<option value="AGRICULTURAL RESEARCH COUNCIL OF NIGERIA (ARCN)">AGRICULTURAL RESEARCH COUNCIL OF NIGERIA (ARCN)</option>
<option value="AHMADU BELLO UNIVERSITY TEACHING HOSPITAL">AHMADU BELLO UNIVERSITY TEACHING HOSPITAL</option>
<option value="AJAOKUTA STEEL COMPANY LIMITED">AJAOKUTA STEEL COMPANY LIMITED</option>
<option value="AMINU KANO UINVERSITY TEACHING HOSPITAL">AMINU KANO UINVERSITY TEACHING HOSPITAL</option>
<option value="ANAMBRA-IMO RIVER BASIN DEVELOPMENT AUTHORITY">ANAMBRA-IMO RIVER BASIN DEVELOPMENT AUTHORITY</option>
<option value="BIO-RESOURCES DEVELOPMENT CENTRE ILORIN">BIO-RESOURCES DEVELOPMENT CENTRE ILORIN</option>
<option value="BIO-RESOURCES DEVELOPMENT CENTRE ISANLU">BIO-RESOURCES DEVELOPMENT CENTRE ISANLU</option>
<option value="BIO-RESOURCES DEVELOPMENT CENTRE KANO">BIO-RESOURCES DEVELOPMENT CENTRE KANO</option>
<option value="BIO-RESOURCES DEVELOPMENT CENTRE KATSINA">BIO-RESOURCES DEVELOPMENT CENTRE KATSINA</option>
<option value="BIORESOURCE DEVELOPMENT CENTRE OWODE - OGUN STATE">BIORESOURCE DEVELOPMENT CENTRE OWODE - OGUN STATE</option>
<option value="BUDGET OFFICE OF THE FEDERATION">BUDGET OFFICE OF THE FEDERATION</option>
<option value="CENTRE FOR ATMOSPHERIC RESEARCH">CENTRE FOR ATMOSPHERIC RESEARCH</option>
<option value="CENTRE FOR BASIC SPACE SCIENCE (CBSS) NSUKKA">CENTRE FOR BASIC SPACE SCIENCE (CBSS) NSUKKA</option>
<option value="CENTRE FOR GEODYESY AND GEO-DYNAMICS, BAUCHI">CENTRE FOR GEODYESY AND GEO-DYNAMICS, BAUCHI</option>
<option value="CENTRE FOR SATELLITE TECHNOLOGY DEVELOPMENT, ABUJA">CENTRE FOR SATELLITE TECHNOLOGY DEVELOPMENT, ABUJA</option>
<option value="CITIZENSHIP AND LEADERSHIP TRAINING CENTRE">CITIZENSHIP AND LEADERSHIP TRAINING CENTRE</option>
<option value="CIVIL DEFENCE FIRE IMMIGRATION AND PRISONS SERVICES BOARD - GARKI">CIVIL DEFENCE FIRE IMMIGRATION AND PRISONS SERVICES BOARD - GARKI</option>
<option value="CODE OF CONDUCT BUREAU">CODE OF CONDUCT BUREAU</option>
<option value="CONSUMER PROTECTION COUNCIL">CONSUMER PROTECTION COUNCIL</option>
<option value="COOPERATIVE INFORMATION NETWORK (COPINE)">COOPERATIVE INFORMATION NETWORK (COPINE)</option>
<option value="COUNCIL FOR THE REGULATION OF ENGINEERING IN NIGERIA">COUNCIL FOR THE REGULATION OF ENGINEERING IN NIGERIA</option>
<option value="COUNCIL FOR THE REGULATION OF FREIGHT FORWARDING IN NIGERIA">COUNCIL FOR THE REGULATION OF FREIGHT FORWARDING IN NIGERIA</option>
<option value="CROSS RIVER NATIONAL PARK">CROSS RIVER NATIONAL PARK</option>
<option value="DEBT MANAGEMENT OFFICE">DEBT MANAGEMENT OFFICE</option>
<option value="ELECTRONICS DEVELOPMENT INSTITUTE (ELDI), AWKA">ELECTRONICS DEVELOPMENT INSTITUTE (ELDI), AWKA</option>
<option value="FEDERAL CHARACTER COMMISSION - FCC">FEDERAL CHARACTER COMMISSION - FCC</option>
<option value="FEDERAL CIVIL SERVICE COMMISSION">FEDERAL CIVIL SERVICE COMMISSION</option>
<option value="FEDERAL COLLEGE OF AGRICULTURAL PRODUCE TECHNOLOGY KANO">FEDERAL COLLEGE OF AGRICULTURAL PRODUCE TECHNOLOGY KANO</option>
<option value="FEDERAL COLLEGE OF AGRICULTURE ISIHAGU">FEDERAL COLLEGE OF AGRICULTURE ISIHAGU</option>
<option value="FEDERAL COLLEGE OF ANIMAL HEALTH AND PRODUCTION TECHNOLOGY VOM">FEDERAL COLLEGE OF ANIMAL HEALTH AND PRODUCTION TECHNOLOGY VOM</option>
<option value="FEDERAL COLLEGE OF COMPLIMENTARY AND ALTERNATIVE MEDICINE">FEDERAL COLLEGE OF COMPLIMENTARY AND ALTERNATIVE MEDICINE</option>
<option value="FEDERAL COLLEGE OF FISHERIES AND MARINE TECHNOLOGY LAGOS">FEDERAL COLLEGE OF FISHERIES AND MARINE TECHNOLOGY LAGOS</option>
<option value=" "> </option>
<option value="FEDERAL COLLEGE OF FORESTRY IBADAN">FEDERAL COLLEGE OF FORESTRY IBADAN</option>
<option value="FEDERAL COLLEGE OF FORESTRY JOS">FEDERAL COLLEGE OF FORESTRY JOS</option>
<option value="FEDERAL COLLEGE OF FORESTRY MECHANIZATION AFAKA">FEDERAL COLLEGE OF FORESTRY MECHANIZATION AFAKA</option>
<option value="FEDERAL COLLEGE OF LAND RESOURCES TECHNOLOGY - KURU">FEDERAL COLLEGE OF LAND RESOURCES TECHNOLOGY - KURU</option>
<option value="FEDERAL COLLEGE OF VETERINARY AND MEDICAL LABORATORY TECHNOLOGY VOM">FEDERAL COLLEGE OF VETERINARY AND MEDICAL LABORATORY TECHNOLOGY VOM</option>
<option value="COOPERATIVE COLLEGE KADUNA">COOPERATIVE COLLEGE KADUNA</option>
<option value="FEDERAL FIRE SERVICE">FEDERAL FIRE SERVICE</option>
<option value="FEDERAL GOVERNMENT STAFF HOUSING LOANS BOARD">FEDERAL GOVERNMENT STAFF HOUSING LOANS BOARD</option>
<option value="FEDERAL INSTITUTE OF INDUSTRIAL RESEARCH">FEDERAL INSTITUTE OF INDUSTRIAL RESEARCH</option>
<option value="FEDERAL MEDICAL CENTRE - GOMBE">FEDERAL MEDICAL CENTRE - GOMBE</option>
<option value="FEDERAL MEDICAL CENTRE - GUSAU">FEDERAL MEDICAL CENTRE - GUSAU</option>
<option value="FEDERAL MEDICAL CENTRE - LOKOJA">FEDERAL MEDICAL CENTRE - LOKOJA</option>
<option value="FEDERAL MEDICAL CENTRE ABEOKUTA">FEDERAL MEDICAL CENTRE ABEOKUTA</option>
<option value="FEDERAL MEDICAL CENTRE ASABA">FEDERAL MEDICAL CENTRE ASABA</option>
<option value="FEDERAL MEDICAL CENTRE AZARE">FEDERAL MEDICAL CENTRE AZARE</option>
<option value="FEDERAL MEDICAL CENTRE KEFFI">FEDERAL MEDICAL CENTRE KEFFI</option>
<option value="FEDERAL MEDICAL CENTRE MAKURDI">FEDERAL MEDICAL CENTRE MAKURDI</option>
<option value="FEDERAL MEDICAL CENTRE UMUAHIA">FEDERAL MEDICAL CENTRE UMUAHIA</option>
<option value="FEDERAL MEDICAL CENTRE YENAGOA">FEDERAL MEDICAL CENTRE YENAGOA</option>
<option value="FEDERAL MIN OF LANDS HOUSING AND URBAN DEV">FEDERAL MIN OF LANDS HOUSING AND URBAN DEV</option>
<option value="FEDERAL MINISTRY OF AGRICULTURE AND RURAL DEVELOPMENT">FEDERAL MINISTRY OF AGRICULTURE AND RURAL DEVELOPMENT</option>
<option value="FEDERAL MINISTRY OF AVIATION">FEDERAL MINISTRY OF AVIATION</option>
<option value="FEDERAL MINISTRY OF CULTURE, TOURISM &amp; NATIONAL ORIENTATION">FEDERAL MINISTRY OF CULTURE, TOURISM &amp; NATIONAL ORIENTATION</option>
<option value="FEDERAL MINISTRY OF EDUCATION">FEDERAL MINISTRY OF EDUCATION</option>
<option value="FEDERAL MINISTRY OF ENVIRONMENT">FEDERAL MINISTRY OF ENVIRONMENT</option>
<option value="FEDERAL MINISTRY OF FINANCE">FEDERAL MINISTRY OF FINANCE</option>
<option value="FEDERAL MINISTRY OF HEALTH">FEDERAL MINISTRY OF HEALTH</option>
<option value="FEDERAL MINISTRY OF INFORMATION">FEDERAL MINISTRY OF INFORMATION</option>
<option value="FEDERAL MINISTRY OF INTERIOR">FEDERAL MINISTRY OF INTERIOR</option>
<option value="FEDERAL MINISTRY OF JUSTICE">FEDERAL MINISTRY OF JUSTICE</option>
<option value="FEDERAL MINISTRY OF LABOUR &amp; PRODUCTIVITY">FEDERAL MINISTRY OF LABOUR &amp; PRODUCTIVITY</option>
<option value="FEDERAL MINISTRY OF MINES AND STEEL DEVELOPMENT">FEDERAL MINISTRY OF MINES AND STEEL DEVELOPMENT</option>
<option value="FEDERAL MINISTRY OF NIGER DELTA AFFAIRS">FEDERAL MINISTRY OF NIGER DELTA AFFAIRS</option>
<option value="FEDERAL MINISTRY OF POLICE AFFAIRS">FEDERAL MINISTRY OF POLICE AFFAIRS</option>
<option value="FEDERAL MINISTRY OF POWER">FEDERAL MINISTRY OF POWER</option>
<option value="FEDERAL MINISTRY OF SCIENCE AND TECHNOLOGY">FEDERAL MINISTRY OF SCIENCE AND TECHNOLOGY</option>
<option value="FEDERAL MINISTRY OF TRADE AND INVESTMENT">FEDERAL MINISTRY OF TRADE AND INVESTMENT</option>
<option value="FEDERAL MINISTRY OF TRANSPORT">FEDERAL MINISTRY OF TRANSPORT</option>
<option value="FEDERAL MINISTRY OF WATER RESOURCES">FEDERAL MINISTRY OF WATER RESOURCES</option>
<option value="FEDERAL MINISTRY OF WOMEN AFFAIRS">FEDERAL MINISTRY OF WOMEN AFFAIRS</option>
<option value="FEDERAL MINISTRY OF WORKS">FEDERAL MINISTRY OF WORKS</option>
<option value="FEDERAL MINISTRY OF YOUTH DEVELOPMENT">FEDERAL MINISTRY OF YOUTH DEVELOPMENT</option>
<option value="FEDERAL NEURO-PSYCHIATRIC HOSPITAL - YABA">FEDERAL NEURO-PSYCHIATRIC HOSPITAL - YABA</option>
<option value=" "> </option>
<option value="FEDERAL NEURO-PSYCHIATRIC HOSPITAL CALABAR">FEDERAL NEURO-PSYCHIATRIC HOSPITAL CALABAR</option>
<option value="FEDERAL NEURO-PSYCHIATRIC HOSPITAL, KADUNA">FEDERAL NEURO-PSYCHIATRIC HOSPITAL, KADUNA</option>
<option value="FEDERAL RADIO CORPORATION OF NIGERIA">FEDERAL RADIO CORPORATION OF NIGERIA</option>
<option value="FEDERAL ROAD MAINTENANCE AGENCY">FEDERAL ROAD MAINTENANCE AGENCY</option>
<option value="FEDERAL ROAD SAFETY CORPS">FEDERAL ROAD SAFETY CORPS</option>
<option value="FEDERAL SCHOOL OF DENTAL TECHNOLOGY AND THERAPY ENUGU">FEDERAL SCHOOL OF DENTAL TECHNOLOGY AND THERAPY ENUGU</option>
<option value="FEDERAL SCHOOL OF MEDICAL LABORATORY TECHNOLOGY SCIENCE- JOS">FEDERAL SCHOOL OF MEDICAL LABORATORY TECHNOLOGY SCIENCE- JOS</option>
<option value="FEDERAL STAFF HOSPITAL JABI">FEDERAL STAFF HOSPITAL JABI</option>
<option value="FEDERAL TEACHING HOSPITAL - ABAKALIKI">FEDERAL TEACHING HOSPITAL - ABAKALIKI</option>
<option value="FGC AZARE">FGC AZARE</option>
<option value="FGC IKOT EKPENE">FGC IKOT EKPENE</option>
<option value="FGC JOS">FGC JOS</option>
<option value="FGC KADUNA">FGC KADUNA</option>
<option value="FGC KANO">FGC KANO</option>
<option value="FGC KEFFI">FGC KEFFI</option>
<option value="FGC KWALI">FGC KWALI</option>
<option value="FGC MAvalueUGURI">FGC MAvalueUGURI</option>
<option value="FGC MINJIBIR">FGC MINJIBIR</option>
<option value="FGC MINNA">FGC MINNA</option>
<option value="FGC ODOGBOLU">FGC ODOGBOLU</option>
<option value="FGC OGBOMOSO">FGC OGBOMOSO</option>
<option value="FGC OHAFIA">FGC OHAFIA</option>
<option value="FGC OKIGWE">FGC OKIGWE</option>
<option value="FGC PORT HARCOURT">FGC PORT HARCOURT</option>
<option value="FGC SOKOTO">FGC SOKOTO</option>
<option value="FGC UGWOLAWO">FGC UGWOLAWO</option>
<option value="FGC VANDEIKYA">FGC VANDEIKYA</option>
<option value="FGC WARRI">FGC WARRI</option>
<option value="FGC ZARIA">FGC ZARIA</option>
<option value="FGC, IKOLE">FGC, IKOLE</option>
<option value="FGGC ABAJI">FGGC ABAJI</option>
<option value="FGGC ABULOMA">FGGC ABULOMA</option>
<option value="FGGC BAKORI">FGGC BAKORI</option>
<option value="FGGC BAUCHI">FGGC BAUCHI</option>
<option value="FGGC BENIN">FGGC BENIN</option>
<option value="FGGC BWARI">FGGC BWARI</option>
<option value="FGGC CALABAR">FGGC CALABAR</option>
<option value="FGGC ENUGU">FGGC ENUGU</option>
<option value="FGGC EZZAMGBO ABAKALIKI">FGGC EZZAMGBO ABAKALIKI</option>
<option value="FGGC GBOKO">FGGC GBOKO</option>
<option value="FGGC GUMI TAMBAWAL">FGGC GUMI TAMBAWAL</option>
<option value="FGGC IBUSA">FGGC IBUSA</option>
<option value="FGGC IKOT-OBIO-ITONG">FGGC IKOT-OBIO-ITONG</option>
<option value=" "> </option>
<option value="FGGC ILORIN">FGGC ILORIN</option>
<option value="FGGC KABBA">FGGC KABBA</option>
<option value="FGGC KEANA">FGGC KEANA</option>
<option value="FGGC LANGTANG">FGGC LANGTANG</option>
<option value="FGGC OMU-ARAN">FGGC OMU-ARAN</option>
<option value="FGGC OYO">FGGC OYO</option>
<option value="FGGC UMUAHIA">FGGC UMUAHIA</option>
<option value="FISCAL RESPONSIBILITY COMMISSION">FISCAL RESPONSIBILITY COMMISSION</option>
<option value="FSC SOKOTO">FSC SOKOTO</option>
<option value="FSTC TUNGBO - YENAGOA">FSTC TUNGBO - YENAGOA</option>
<option value="FSTC,DOMA">FSTC,DOMA</option>
<option value="FTC OHANSO">FTC OHANSO</option>
<option value="FTC OROZO">FTC OROZO</option>
<option value="FTC OTOBI">FTC OTOBI</option>
<option value="FTC OTUPKO">FTC OTUPKO</option>
<option value="FTC UYO">FTC UYO</option>
<option value="FTC ZURU">FTC ZURU</option>
<option value="GASHAKA GUMTI NATIONAL PARK">GASHAKA GUMTI NATIONAL PARK</option>
<option value="HADEJIA JEMAARE RIVER BASIN DEVELOPMENT AUTHORITY KANO">HADEJIA JEMAARE RIVER BASIN DEVELOPMENT AUTHORITY KANO</option>
<option value="HEALTH RECORDS OFFICERS REGISTRATION BOARD OF NIGERIA">HEALTH RECORDS OFFICERS REGISTRATION BOARD OF NIGERIA</option>
<option value="HYDRAULIC EQUIPMENT DEVELOPMENT INSTITUTE KANO">HYDRAULIC EQUIPMENT DEVELOPMENT INSTITUTE KANO</option>
<option value="INSTITUTE OF ARCHAEOLOGY AND MUSEUM STUDIES - JOS">INSTITUTE OF ARCHAEOLOGY AND MUSEUM STUDIES - JOS</option>
<option value="JOINT ADMISSIONS AND MATRICULATION BOARD">JOINT ADMISSIONS AND MATRICULATION BOARD</option>
<option value="JOS UNIVERSITY TEACHING HOSPITAL - JOS">JOS UNIVERSITY TEACHING HOSPITAL - JOS</option>
<option value="KING"S COLLEGE">KING"S COLLEGE</option>
<option value="LEGAL Avalue COUNCIL OF NIGERIA">LEGAL Avalue COUNCIL OF NIGERIA</option>
<option value="LOWER NIGER RIVER BASIN DEVELOPMENT AUTHORITY ILORIN">LOWER NIGER RIVER BASIN DEVELOPMENT AUTHORITY ILORIN</option>
<option value="MARITIME ACADEMY OF NIGERIA - ORON">MARITIME ACADEMY OF NIGERIA - ORON</option>
<option value="MICHAEL IMOUDU NATIONAL INSTITUTE FOR LABOUR STUDIES">MICHAEL IMOUDU NATIONAL INSTITUTE FOR LABOUR STUDIES</option>
<option value="MIN OF COMMUNICATION TECHNOLOGY">MIN OF COMMUNICATION TECHNOLOGY</option>
<option value="MINISTRY OF DEFENCE - MOD">MINISTRY OF DEFENCE - MOD</option>
<option value="MINISTRY OF FOREIGN AFFAIRS">MINISTRY OF FOREIGN AFFAIRS</option>
<option value="NATIONAL AGENCY FOR FOOD AND DRUG ADMINISTRATION CONTROL (NAFDAC)">NATIONAL AGENCY FOR FOOD AND DRUG ADMINISTRATION CONTROL (NAFDAC)</option>
<option value="NATIONAL AGENCY FOR SCIENCE AND ENGINEERING INFRASTRUCTRE">NATIONAL AGENCY FOR SCIENCE AND ENGINEERING INFRASTRUCTRE</option>
<option value="NATIONAL AGRICULTURE SEEDS COUNCIL">NATIONAL AGRICULTURE SEEDS COUNCIL</option>
<option value="NATIONAL AUTOMOTIVE DESIGN AND DEVELOPMENT COUNCIL (NADDC)">NATIONAL AUTOMOTIVE DESIGN AND DEVELOPMENT COUNCIL (NADDC)</option>
<option value="NATIONAL BIOTECHNOLOGY DEVELOPMENT AGENCY (NABDA)">NATIONAL BIOTECHNOLOGY DEVELOPMENT AGENCY (NABDA)</option>
<option value="NATIONAL BOUNDARY COMMISSION">NATIONAL BOUNDARY COMMISSION</option>
<option value="NATIONAL BROADCASTING COMMISSION">NATIONAL BROADCASTING COMMISSION</option>
<option value="NATIONAL BUREAU OF STATISTICS">NATIONAL BUREAU OF STATISTICS</option>
<option value="NATIONAL BUSINESS AND TECHNICAL EXAMINATION BOARD">NATIONAL BUSINESS AND TECHNICAL EXAMINATION BOARD</option>
<option value="NATIONAL CENTRE FOR GENETIC RESOURCES AND BIOTECHNOLOGY">NATIONAL CENTRE FOR GENETIC RESOURCES AND BIOTECHNOLOGY</option>
<option value="NATIONAL CENTRE FOR REMOTE SENSING, JOS">NATIONAL CENTRE FOR REMOTE SENSING, JOS</option>
<option value=" "> </option>
<option value="NATIONAL CEREALS RESEARCH INSTITUTE, BADEGGI">NATIONAL CEREALS RESEARCH INSTITUTE, BADEGGI</option>
<option value="NATIONAL COMMISSION FOR MUSEUM AND MONUMENTS">NATIONAL COMMISSION FOR MUSEUM AND MONUMENTS</option>
<option value="NATIONAL COMMISSION FOR REFUGEES MIGRATION AND INTERNAL DISPLACED PERSONS">NATIONAL COMMISSION FOR REFUGEES MIGRATION AND INTERNAL DISPLACED PERSONS</option>
<option value="NATIONAL COUNCIL OF ARTS AND CULTURE">NATIONAL COUNCIL OF ARTS AND CULTURE</option>
<option value="NATIONAL DIRECTORATE OF EMPLOYMENT">NATIONAL DIRECTORATE OF EMPLOYMENT</option>
<option value="NATIONAL DRUG LAW ENFORCEMENT AGENCY">NATIONAL DRUG LAW ENFORCEMENT AGENCY</option>
<option value="NATIONAL EAR CARE CENTRE KADUNA">NATIONAL EAR CARE CENTRE KADUNA</option>
<option value="NATIONAL EMERGENCY MANAGEMENT AGENCY (NEMA)">NATIONAL EMERGENCY MANAGEMENT AGENCY (NEMA)</option>
<option value="NATIONAL ENGINEERING DESIGN DEVELOPMENT INSTITUTE (NEDDI) ANAMBRA">NATIONAL ENGINEERING DESIGN DEVELOPMENT INSTITUTE (NEDDI) ANAMBRA</option>
<option value="NATIONAL EXAMINATION COUNCIL - NECO">NATIONAL EXAMINATION COUNCIL - NECO</option>
<option value="NATIONAL EYE CENTRE KADUNA">NATIONAL EYE CENTRE KADUNA</option>
<option value="NATIONAL FILM AND VvalueEO CENSORS BOARD">NATIONAL FILM AND VvalueEO CENSORS BOARD</option>
<option value="NATIONAL GALLERY OF ARTS">NATIONAL GALLERY OF ARTS</option>
<option value="NATIONAL HORTICULTURAL RESEARCH INSTITUTE IBADAN">NATIONAL HORTICULTURAL RESEARCH INSTITUTE IBADAN</option>
<option value="NATIONAL HOSPITAL - ABUJA">NATIONAL HOSPITAL - ABUJA</option>
<option value="NATIONAL INLAND WATERWAYS AUTHORITY">NATIONAL INLAND WATERWAYS AUTHORITY</option>
<option value="NATIONAL INSTITUTE FOR HOSPITALITY AND TOURISM">NATIONAL INSTITUTE FOR HOSPITALITY AND TOURISM</option>
<option value="NATIONAL INSTITUTE FOR POLICY AND STRATEGIC STUDIES KURU">NATIONAL INSTITUTE FOR POLICY AND STRATEGIC STUDIES KURU</option>
<option value="NATIONAL IRON ORE MINING COMPANY LIMITED">NATIONAL IRON ORE MINING COMPANY LIMITED</option>
<option value="NATIONAL LIBRARY OF NIGERIA">NATIONAL LIBRARY OF NIGERIA</option>
<option value="NATIONAL LOTTERY REGULATORY COMMISSION">NATIONAL LOTTERY REGULATORY COMMISSION</option>
<option value="NATIONAL METALLURGICAL DEVELOPMENT CENTRE JOS">NATIONAL METALLURGICAL DEVELOPMENT CENTRE JOS</option>
<option value="OFFICE FOR TECHNOLOGY ACQUISITION AND PROMOTION (NOTAP)">OFFICE FOR TECHNOLOGY ACQUISITION AND PROMOTION (NOTAP)</option>
<option value="NATIONAL OIL SPILL DETECTION AND RESPONSE AGENCY">NATIONAL OIL SPILL DETECTION AND RESPONSE AGENCY</option>
<option value="NATIONAL ORIENTATION AGENCY">NATIONAL ORIENTATION AGENCY</option>
<option value="NATIONAL ORTHOPAEDIC HOSPITAL- DALA KANO">NATIONAL ORTHOPAEDIC HOSPITAL- DALA KANO</option>
<option value="NATIONAL PARK HEADQUARTERS">NATIONAL PARK HEADQUARTERS</option>
<option value="NATIONAL PLANNING COMMISSION">NATIONAL PLANNING COMMISSION</option>
<option value="NATIONAL POPULATION COMMISSION">NATIONAL POPULATION COMMISSION</option>
<option value="NATIONAL PRIMARY HEALTH CARE DEVELOPMENT AGENCY (NPHCDA)">NATIONAL PRIMARY HEALTH CARE DEVELOPMENT AGENCY (NPHCDA)</option>
<option value="NATIONAL PRODUCTIVITY CENTRE">NATIONAL PRODUCTIVITY CENTRE</option>
<option value="NATIONAL RESEARCH INSTITUTE FOR CHEMICAL TECHNOLOGY">NATIONAL RESEARCH INSTITUTE FOR CHEMICAL TECHNOLOGY</option>
<option value="NATIONAL ROOT CROPS RESEARCH INSTITUTE UMUDIKE">NATIONAL ROOT CROPS RESEARCH INSTITUTE UMUDIKE</option>
<option value="NATIONAL SALARIES INCOMES AND WAGES COMMISSION">NATIONAL SALARIES INCOMES AND WAGES COMMISSION</option>
<option value="NATIONAL SPACE RESEARCH AND DEV AGENCY (NASRDA)">NATIONAL SPACE RESEARCH AND DEV AGENCY (NASRDA)</option>
<option value="NATIONAL SPORTS COMMISSION">NATIONAL SPORTS COMMISSION</option>
<option value="NATIONAL STEEL RAW MATERIALS EXPLORATION AGENCY">NATIONAL STEEL RAW MATERIALS EXPLORATION AGENCY</option>
<option value="NATIONAL TEACHERS INSTITUTE KADUNA">NATIONAL TEACHERS INSTITUTE KADUNA</option>
<option value="NATIONAL THEATRE - IGANMU">NATIONAL THEATRE - IGANMU</option>
<option value="NATIONAL UNIVERSITIES COMMISSION">NATIONAL UNIVERSITIES COMMISSION</option>
<option value="NATIONAL VETERINARY RESEARCH INSTITUTE - VOM PLATEAU">NATIONAL VETERINARY RESEARCH INSTITUTE - VOM PLATEAU</option>
<option value="NATIONAL YOUTH SERVICE CORPS">NATIONAL YOUTH SERVICE CORPS</option>
<option value="NEUROPSYCHIATRIC HOSPITAL - ARO">NEUROPSYCHIATRIC HOSPITAL - ARO</option>
<option value=" "> </option>
<option value="NEW PARTNERSHIP FOR AFRICA"S DEVELOPMENT (NEPAD)">NEW PARTNERSHIP FOR AFRICA"S DEVELOPMENT (NEPAD)</option>
<option value="NEWS AGENCY OF NIGERIA (NAN)">NEWS AGENCY OF NIGERIA (NAN)</option>
<option value="NIGER DELTA BASIN DEVELOPMENT AUTHORITY">NIGER DELTA BASIN DEVELOPMENT AUTHORITY</option>
<option value="NIGERIAN BUILDING AND ROAD RESEARCH INSTITUTE">NIGERIAN BUILDING AND ROAD RESEARCH INSTITUTE</option>
<option value="NIGERIAN COLLEGE OF AVIATION TECHNOLOGY">NIGERIAN COLLEGE OF AVIATION TECHNOLOGY</option>
<option value="NIGERIAN COMMUNICATIONS SATELLITE LIMITED (NIGCOMSAT)">NIGERIAN COMMUNICATIONS SATELLITE LIMITED (NIGCOMSAT)</option>
<option value="NIGERIAN COPYRIGHT COMMISSION">NIGERIAN COPYRIGHT COMMISSION</option>
<option value="NIGERIAN EXPORT PROMOTION COUNCIL">NIGERIAN EXPORT PROMOTION COUNCIL</option>
<option value="NIGERIAN FILM CORPORATION">NIGERIAN FILM CORPORATION</option>
<option value="NIGERIAN INST OF ADVANCED LEGAL STUDIES">NIGERIAN INST OF ADVANCED LEGAL STUDIES</option>
<option value="NIGERIAN INSTITUTE FOR TRYPANOSOMIASIS RESEARCH">NIGERIAN INSTITUTE FOR TRYPANOSOMIASIS RESEARCH</option>
<option value="NIGERIAN LAW REFORM COMMISSION">NIGERIAN LAW REFORM COMMISSION</option>
<option value="NIGERIAN METEOROLOGICAL AGENCY">NIGERIAN METEOROLOGICAL AGENCY</option>
<option value="NIGERIAN POSTAL SERVICE">NIGERIAN POSTAL SERVICE</option>
<option value="NIGERIAN RAILWAY CORPORATION">NIGERIAN RAILWAY CORPORATION</option>
<option value="NIGERIAN STORED PRODUCTS RESEARCH INSTITUTE ILORIN">NIGERIAN STORED PRODUCTS RESEARCH INSTITUTE ILORIN</option>
<option value="NIGERIAN TELEVISION AUTHORITY">NIGERIAN TELEVISION AUTHORITY</option>
<option value="NIGERIAN TOURISM DEVELOPMENT CORPORATION">NIGERIAN TOURISM DEVELOPMENT CORPORATION</option>
<option value="NNAMDI AZIKIWE UNIVERSITY TEACHING HOSPITAL">NNAMDI AZIKIWE UNIVERSITY TEACHING HOSPITAL</option>
<option value="NURSING AND MvalueWIFERY COUNCIL OF NIGERIA">NURSING AND MvalueWIFERY COUNCIL OF NIGERIA</option>
<option value="OFFICE OF THE ACCOUNTANT GENERAL OF THE FEDERATION">OFFICE OF THE ACCOUNTANT GENERAL OF THE FEDERATION</option>
<option value="OFFICE OF THE AUDITOR GENERAL OF THE FEDERATION-OAUGF">OFFICE OF THE AUDITOR GENERAL OF THE FEDERATION-OAUGF</option>
<option value="OFFICE OF THE HEAD OF CIVIL SERVICE OF THE FEDERATION">OFFICE OF THE HEAD OF CIVIL SERVICE OF THE FEDERATION</option>
<option value="OFFICE OF THE SECRETARY TO THE GOVERNMENT OF THE FEDERATION (OSGF)">OFFICE OF THE SECRETARY TO THE GOVERNMENT OF THE FEDERATION (OSGF)</option>
<option value="OFFICE OF THE SURVEYOR GENERAL OF THE FEDERATION">OFFICE OF THE SURVEYOR GENERAL OF THE FEDERATION</option>
<option value="OGUN-OSHUN RIVER BASIN DEVELOPMENT AUTHORITY">OGUN-OSHUN RIVER BASIN DEVELOPMENT AUTHORITY</option>
<option value="OYO NATIONAL PARK">OYO NATIONAL PARK</option>
<option value="POLICE SERVICE COMMISSION">POLICE SERVICE COMMISSION</option>
<option value="POWER EQUIPMENT AND ELECTRICAL MACHINERY DEVELOPMENT INSTITUTE">POWER EQUIPMENT AND ELECTRICAL MACHINERY DEVELOPMENT INSTITUTE</option>
<option value="PROJECT DEVELOPMENT INSTITUTE ENUGU - PRODA">PROJECT DEVELOPMENT INSTITUTE ENUGU - PRODA</option>
<option value="QUEEN"S COLLEGE LAGOS">QUEEN"S COLLEGE LAGOS</option>
<option value="REVENUE MOBILISATION ALLOCATION AND FISCAL COMMISSION">REVENUE MOBILISATION ALLOCATION AND FISCAL COMMISSION</option>
<option value="SCIENTIFIC EQUIPMENT DEVEIOPMENT INSTITUTE(SEDI)ENUGU">SCIENTIFIC EQUIPMENT DEVEIOPMENT INSTITUTE(SEDI)ENUGU</option>
<option value="SCIENTIFIC EQUIPMENT DEVELOPMENT INSTITUTE, MINNA">SCIENTIFIC EQUIPMENT DEVELOPMENT INSTITUTE, MINNA</option>
<option value="SHEDA SCIENCE AND TECH COMPLEX (SHESTCO">SHEDA SCIENCE AND TECH COMPLEX (SHESTCO</option>
<option value="SOKOTO RIMA RIVER BASIN DEVELOPMENT AUTHORITY">SOKOTO RIMA RIVER BASIN DEVELOPMENT AUTHORITY</option>
<option value="STANDARD ORGANISATION OF NIGERIA (SON)">STANDARD ORGANISATION OF NIGERIA (SON)</option>
<option value="TEACHERS REGISTRATION COUNCIL OF NIGERIA ABUJA">TEACHERS REGISTRATION COUNCIL OF NIGERIA ABUJA</option>
<option value="TECHNOLOGY BUSINESS INCUBATOR CENTRE - ABEOKUTA">TECHNOLOGY BUSINESS INCUBATOR CENTRE - ABEOKUTA</option>
<option value="TECHNOLOGY BUSINESS INCUBATOR CENTRE - BAUCHI">TECHNOLOGY BUSINESS INCUBATOR CENTRE - BAUCHI</option>
<option value="TECHNOLOGY BUSINESS INCUBATOR CENTRE - IBADAN">TECHNOLOGY BUSINESS INCUBATOR CENTRE - IBADAN</option>
<option value="TECHNOLOGY BUSINESS INCUBATOR CENTRE - ILORIN">TECHNOLOGY BUSINESS INCUBATOR CENTRE - ILORIN</option>
<option value="TECHNOLOGY BUSINESS INCUBATOR CENTRE - KADUNA">TECHNOLOGY BUSINESS INCUBATOR CENTRE - KADUNA</option>
<option value=" "> </option>
<option value="TECHNOLOGY BUSINESS INCUBATOR CENTRE - KANO">TECHNOLOGY BUSINESS INCUBATOR CENTRE - KANO</option>
<option value="TECHNOLOGY BUSINESS INCUBATOR CENTRE - MINNA">TECHNOLOGY BUSINESS INCUBATOR CENTRE - MINNA</option>
<option value="TECHNOLOGY BUSINESS INCUBATOR CENTRE - OKWE ONUIMO">TECHNOLOGY BUSINESS INCUBATOR CENTRE - OKWE ONUIMO</option>
<option value="TECHNOLOGY BUSINESS INCUBATOR CENTRE - YENEGOA">TECHNOLOGY BUSINESS INCUBATOR CENTRE - YENEGOA</option>
<option value="UNICALABAR TEACHING HOSPITAL - CALABAR">UNICALABAR TEACHING HOSPITAL - CALABAR</option>
<option value="UNILORIN TEACHING HOSPITAL - ILORIN">UNILORIN TEACHING HOSPITAL - ILORIN</option>
<option value="UNIVERSITY COLLEGE HOSPITAL - IBADAN">UNIVERSITY COLLEGE HOSPITAL - IBADAN</option>
<option value="UNIVERSITY OF ABUJA FEDERAL SPECIALIST HOSPITAL - GWAGWALADA">UNIVERSITY OF ABUJA FEDERAL SPECIALIST HOSPITAL - GWAGWALADA</option>
<option value="UNIVERSITY OF BENIN TEACHING HOSPITAL - BENIN CITY">UNIVERSITY OF BENIN TEACHING HOSPITAL - BENIN CITY</option>
<option value="UNIVERSITY OF NIGERIA TEACHING HOSPITAL - ENUGU">UNIVERSITY OF NIGERIA TEACHING HOSPITAL - ENUGU</option>
<option value="UNIVERSITY OF UYO TEACHING HOSPITAL">UNIVERSITY OF UYO TEACHING HOSPITAL</option>
<option value="VETERINARY COUNCIL OF NIGERIA">VETERINARY COUNCIL OF NIGERIA</option>
<option value="VOICE OF NIGERIA (VON)">VOICE OF NIGERIA (VON)</option>
<option value="DANFODIYO UNIVERSITY TEACHING HOSPITAL">DANFODIYO UNIVERSITY TEACHING HOSPITAL</option>
<option value="OFFICE OF HEAD OF SERVICE">OFFICE OF HEAD OF SERVICE</option>
<option value="OFFICE OF THE SSG">OFFICE OF THE SSG</option>
<option value="OFFICE OF THE SURVEYOR-GENERAL ">OFFICE OF THE SURVEYOR-GENERAL </option>
<option value=" "> </option>
<option value="OFFICE OF THE SURVEYOR-GENERAL ">OFFICE OF THE SURVEYOR-GENERAL </option>
<option value="Nigeria Immigration Service">Nigeria Immigration Service</option>
<option value="Federal Road Safety Commission (FRSC)">Federal Road Safety Commission (FRSC)</option>
<option value="National Agency for the Prohibition of 
Trafficking in Persons (NAPTIP)Nigeria">National Agency for the Prohibition of 
Trafficking in Persons (NAPTIP)Nigeria</option>
<option value="Police Service Commission">Police Service Commission</option>
<option value="Nigeria Police Force">Nigeria Police Force</option>
<option value="Nigeria Police Trust Fund">Nigeria Police Trust Fund</option>
            </select>
                     </div>
                   </div>
                   
                   <div class="uk-margin">
                     <label class="uk-form-label" for="form-horizontal-text">MDA's Address</label>
                     <div class="uk-form-controls">
                        <textarea class="uk-textarea" rows="5" placeholder="Enter MDA's Address" id="oaddress" name="oaddress" aria-label="Textarea" style="border-radius:5px;width:200px;height:45px"></textarea>
                     </div>
                   </div>
                </div>
              
              
              
          
          <br><br>
         <a href="#" uk-switcher-item="previous" class="button-34"><span uk-icon="icon: arrow-left"></span> Previous</a>
         <a href="#" uk-switcher-item="next" class="button-34 uk-align-right">Proceed <span uk-icon="icon: arrow-right"></span></a>
         </fieldset>
      </li>
      
      <li>
            <h3 class="uk-card-title uk-text-lead uk-text-bolder uk-text-center"
             style="color:#3b3e7f">LOAN</h3>
             <small class="uk-align-center" align="center">Provide the information below</small>
           <fieldset class="uk-fieldset">

              <legend class="uk-legend">Loan Details</legend>
               <div class="uk-form-horizontal uk-margin-large">

                  <div class="uk-margin">
                     <label class="uk-form-label" for="form-horizontal-text">Loan Amount</label>
                     <div class="uk-form-controls">
                      <input class="uk-input" type="tel" onkeyup="this.value=this.value.replace(/[^\d]/,'')" name="loanamt" placeholder="Loan Amount" id="loanamt" style="border-radius:5px;width:200px;height:45px">
                     </div>
                   </div>
                   
                   <div class="uk-margin">
                     <label class="uk-form-label" for="form-horizontal-text">Loan Tenure</label>
                     <div class="uk-form-controls">
                         <select class="uk-input" name="tenor" id="tenorsel" onchange="changeFunc();"  style="border-radius:5px;width:200px;height:45px">
            <option selected disabled>Select Tenor</option>
            <option value="1">1 Month</option>
            <option value="2">2 Months</option>
            <option value="3">3 Months</option>
            <option value="4">4 Months</option>
            <option value="5">5 Months</option>
            <option value="6">6 Months</option>
            <option value="7">7 Months</option>
            <option value="8">8 Months</option>
            <option value="9">9 Months</option>
             <option value="10">10 Months</option>
              <option value="11">11 Months</option>
               <option value="12">12 Months</option>
        </select>
                     </div>
                   </div>
                   
                    <div class="uk-margin">
                     <label class="uk-form-label" for="form-horizontal-text">Loan Type</label>
                     <div class="uk-form-controls">
                      <select class="uk-input" name="lpop" id="lpop" style="width:200px;height:45px">
            <option selected disabled>Select Loan Type</option>
            <option value="Payday">Payday</option>
           
        </select>
                     </div>
                   </div>
                   
                    <div class="uk-margin">
                         <label class="uk-form-label" for="form-horizontal-text">Monthly Repayment</label>
                         <div class="uk-form-controls">
                                <input class="uk-input" id="mrepay" type="text" placeholder="0" style="border-radius:5px" disabled>
        <input type="hidden" id="mrepay2" name="mrepay" style="border-radius:5px;width:200px;height:45px">
                         </div>
                    </div>
                    
                    <div class="uk-margin">
                         <label class="uk-form-label" for="form-horizontal-text">Total Repayment</label>
                         <div class="uk-form-controls">
                                  <input class="uk-input" id="trepay" type="text" style="border-radius:5px" disabled> 
        <input type="hidden" id="trepay2" name="trepay" style="border-radius:5px;width:200px;height:45px">
                         </div>
                    </div>
                    
                    
          <div class="uk-margin">
                         <label class="uk-form-label" for="form-horizontal-text">Refering Account Officer</label>
                         <div class="uk-form-controls">
                                  <input class="uk-input" type="text" id="rao" name="rao" placeholder="Name Of Account Officer" aria-label="Input" style="border-radius:5px">
                         </div>
                    </div>           
                    
                    

                    
                     <div class="uk-margin">
            <p class="uk-text-bold"><a href="#modaltc" uk-toggle>See Terms and Conditions</a> <span style="color:red">*</span></p>
    
      <p>
            <label><input class="uk-checkbox" name="isagree"  type="checkbox" id="tc" required> I Agree</label>
      </p>  
      <p>
          <div class="uk-alert-primary" uk-alert>
    <a class="uk-alert-close" uk-close></a>
    <p>By clicking Submit button below I consent to Fullrange Microfinance bank Limited to view my Salary History and to check my loan eligibility.</p>
</div>
      </p>
        </div>
        <input type="hidden" value="<?php echo e($interest); ?>" id="intr">
        <script>
             function changeFunc() {
                var loanamt =  document.getElementById("loanamt").value;
                var trepay =  document.getElementById("trepay");
                var interest =  document.getElementById("intr").value;
		     	var selectBox = document.getElementById("tenorsel").selectedIndex;
											var seleindex = selectBox;
											if(seleindex == 1){
											 var ns = "\u20A6";
								 var intamt = interest*1*loanamt;
											 var totalamt = Number(loanamt)+Number(intamt);
							
								var monthlypay = totalamt / 1;
											
							document.getElementById("mrepay").value = ns+monthlypay;
											  document.getElementById("mrepay2").value =  monthlypay;
											 document.getElementById("trepay").value =  ns+totalamt;
											 document.getElementById("trepay2").value =  totalamt;
											 
											 
											}
											
											if(seleindex == 2){
										      var ns = "\u20A6";
								 var intamt = interest*2*loanamt;
											var totalamt = Number(loanamt)+Number(intamt);
								
								var monthlypay = totalamt / 2;
											
							document.getElementById("mrepay").value = ns+monthlypay;
											  document.getElementById("mrepay2").value =  monthlypay;
											 document.getElementById("trepay").value =  ns+totalamt;
											 document.getElementById("trepay2").value =  totalamt;
											}
											if(seleindex == 3){
											 var ns = "\u20A6";
								 var intamt = interest*3*loanamt;
											var totalamt = Number(loanamt)+Number(intamt);
								
								var monthlypay = totalamt / 3;
											
							document.getElementById("mrepay").value = ns+monthlypay;
											  document.getElementById("mrepay2").value =  monthlypay;
											 document.getElementById("trepay").value =  ns+totalamt;
											 document.getElementById("trepay2").value =  totalamt;
											}
											if(seleindex == 4){
											 var ns = "\u20A6";
								 var intamt = interest*4*loanamt;
											var totalamt = Number(loanamt)+Number(intamt);
								
								var monthlypay = totalamt / 4;
											
							document.getElementById("mrepay").value = ns+monthlypay;
											  document.getElementById("mrepay2").value =  monthlypay;
											 document.getElementById("trepay").value =  ns+totalamt;
											 document.getElementById("trepay2").value =  totalamt;
											}
											if(seleindex == 5){
											 var ns = "\u20A6";
								 var intamt = interest*5*loanamt;
											var totalamt = Number(loanamt)+Number(intamt);
								
								var monthlypay = totalamt / 5;
											
							document.getElementById("mrepay").value = ns+monthlypay;
											  document.getElementById("mrepay2").value =  monthlypay;
											 document.getElementById("trepay").value =  ns+totalamt;
											 document.getElementById("trepay2").value =  totalamt;
											}
											if(seleindex == 6){
											 var ns = "\u20A6";
								 var intamt = interest*6*loanamt;
											var totalamt = Number(loanamt)+Number(intamt);
								
								var monthlypay = totalamt / 6;
											
							document.getElementById("mrepay").value = ns+monthlypay;
											  document.getElementById("mrepay2").value =  monthlypay;
											 document.getElementById("trepay").value =  ns+totalamt;
											 document.getElementById("trepay2").value =  totalamt;
											}
											if(seleindex == 7){
											 var ns = "\u20A6";
								 var intamt = interest*7*loanamt;
											var totalamt = Number(loanamt)+Number(intamt);
								
								var monthlypay = totalamt / 7;
											
							document.getElementById("mrepay").value = ns+monthlypay;
											  document.getElementById("mrepay2").value =  monthlypay;
											 document.getElementById("trepay").value =  ns+totalamt;
											 document.getElementById("trepay2").value =  totalamt;
											}
											if(seleindex == 8){
											 var ns = "\u20A6";
								 var intamt = interest*8*loanamt;
											var totalamt = Number(loanamt)+Number(intamt);
								
								var monthlypay = totalamt / 8;
											
							document.getElementById("mrepay").value = ns+monthlypay;
											  document.getElementById("mrepay2").value =  monthlypay;
											 document.getElementById("trepay").value =  ns+totalamt;
											 document.getElementById("trepay2").value =  totalamt;
											}
											
											if(seleindex == 9){
											var ns = "\u20A6";
								 var intamt = interest*9*loanamt;
											var totalamt = Number(loanamt)+Number(intamt);
								
								var monthlypay = totalamt / 9;
											
							document.getElementById("mrepay").value = ns+monthlypay;
											  document.getElementById("mrepay2").value =  monthlypay;
											 document.getElementById("trepay").value =  ns+totalamt;
											 document.getElementById("trepay2").value =  totalamt;
											}
											
											if(seleindex == 10){
											var ns = "\u20A6";
								 var intamt = interest*10*loanamt;
											var totalamt = Number(loanamt)+Number(intamt);
								
								var monthlypay = totalamt / 10;
											
							document.getElementById("mrepay").value = ns+monthlypay;
											  document.getElementById("mrepay2").value =  monthlypay;
											 document.getElementById("trepay").value =  ns+totalamt;
											 document.getElementById("trepay2").value =  totalamt;
											}
											
											if(seleindex == 11){
											var ns = "\u20A6";
								 var intamt = interest*11*loanamt;
											var totalamt = Number(loanamt)+Number(intamt);
								
								var monthlypay = totalamt / 11;
											
							document.getElementById("mrepay").value = ns+monthlypay;
											  document.getElementById("mrepay2").value =  monthlypay;
											 document.getElementById("trepay").value =  ns+totalamt;
											 document.getElementById("trepay2").value =  totalamt;
											}
									
									if(seleindex == 12){
											var ns = "\u20A6";
								 var intamt = interest*12*loanamt;
											var totalamt = Number(loanamt)+Number(intamt);
								
								var monthlypay = totalamt / 12;
											
							document.getElementById("mrepay").value = ns+monthlypay;
											  document.getElementById("mrepay2").value =  monthlypay;
											 document.getElementById("trepay").value =  ns+totalamt;
											 document.getElementById("trepay2").value =  totalamt;
											}
									
									
									
											

									   }

         </script>
                   
                </div>
          
          <br><br>
         <a href="#" uk-switcher-item="previous" class="button-34">Previous</a>
    <button type="button" id="btnsubmit" class="button-34 uk-align-right">Submit</button>
          </fieldset>
      </li>
</ul>
    </div>
        </div>
    </div>
    
 </form>   
   
    
    
    
    
      </div>
       <br> <br> <br> <br> <br> <br> <br> <br> <br> <br>
        <br> <br> <br> <br> <br> <br> <br> <br> <br> <br>
         <br> <br> <br> <br> <br> <br> <br> <br> <br> <br>
          <br> <br> <br> <br> <br> <br> <br> <br> <br> <br>
          
          
           <div id="modaltc" style="border-radius:15px" uk-modal>
    <div class="uk-modal-dialog">

        <button class="uk-modal-close-default" type="button" uk-close></button>

        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Read Terms & Conditions</h2>
        </div>

        <div class="uk-modal-body" uk-overflow-auto>

             
	<h2><b>FULLRANGE MFB LTD LOAN AGREEMENT</b></h2>
	<p>Pricing: Interest: 4% flat monthly.</p>
	<h2>RIGHT OF SET OFF (GLOBAL STANDING INSTRUCTION)</h2>
	<ol>
		<li>"By accepting this offer letter/loan agreement, and by drawing on the loan, I /We covenant to repay the loan as at when due. In the event that  I/ We fail to repay the loan as agreed, and the loan becomes delinquent, the <b>FULLRANGE MFB</b> shall have the right to report the delinquent loan to the CBN through the Credit Risk Management System (CRMS) or by any other means and request the CBN to exercise its regulatory powers to direct all <b>FULLRANGE MFB</b> and other financial institutions under its regulatory purview to set-off my/our indebtedness to you from any in any <b>FULLRANGE MFB LTD</b> account and from any financial assets that may be holding to my/our benefit."</li>
		<li>"I/ We covenant and warrant that the <b>FULLRANGE MFB</b> shall have the power to set-off my/our indebtedness under this loan agreement from all such monies and funds standing to my/our credit/benefit in any or all such accounts or from any other financial assets belonging to me/us and in the custody of any <b>FULLRANGE MFB</b>."</li>
		<li>"I/We hereby waive any right of confidentiality whether arising under common law or statute or in any manner whatsoever and irrevocably agree that I shall not argue to the contrary before any court of law, tribunal or any administrative authority or anybody acting in judicial or quasi-judicial capacity"</li>
	</ol>
	<h2>ACCELERATION OF PAYMENT IN EVENT OF DEFAULT</h2>
	<p>Without prejudice <b>FULLRANGE MFB LTD</b> has right to enforce a “Bullet Repayment” of outstanding loan amount at any time, any or of the following events shall cause the <b>FULLRANGE MFB</b> to accelerate repayment as due for immediate liquidation:</p>
	<ul>
		<li>The <b>FULLRANGE MFB</b> reserves the right to recall if it is found to be diverted for other purposes other than the purpose for which the facility was granted</li>
		<li>If the Borrower defaults in the performance or observance of any other term, condition or covenant contained in this offer letter and such breach or default continues remedied after (7) days’ notice to the borrower by the <b>FULLRANGE MFB</b>.</li>
		<li>If an order is issued or an effective resolution is passed or a winding-up petition is levied upon the Borrower.</li>
		<li>If the borrower ceases or threatens to cease to carry on its business.</li>
		<li>If there is any material change in the character of the Borrower which the <b>FULLRANGE MFB</b> considers significantly adverse to its interest as a lender.</li>
	</ul>
	<h2>PENALTY</h2>
	<ul>
		<li>The Borrower shall upon maturity of the loan or on demand by <b>FULLRANGE MFB</b>, repay any outstanding in full, failure of which the borrower will be liable to pay 1% daily penalty in addition to the monthly interest rate or in accordance with the <b>FULLRANGE MFB`s</b> penalty rate at the time of default.</li>
		<li>Penal charges of 4% on outstanding balance will be applied on Pre liquidation of loan plus the accrued interest for the period irrespective of the loan tenor.</li>
		
		<p><strong>RECOVERY/SECURITY REALIZATION:</strong></p>
<p><b>FULLRANGE MFB</b> shall immediately, upon the expiration of the loan tenure or upon demand commence recovery actions and enforce all legal remedies against the borrower.</p>
<p>All costs, charges or expenses incurred by the <b>FULLRANGE MFB</b>, directly or indirectly in the process of recovering or attempting to recover the outstanding amount or in the process of perfecting, discharging and/or enforcing any pledged securities for this facility shall be borne by the borrower. <b>FULLRANGE MFB</b> will advise the Borrower of such charges, costs or expenses for immediate settlement.</p>
<p>Kindly confirm your acceptance of this offer by accepting.</p>
<p><i>Yours faithfully,</i><br>FOR: 
<b>FULLRANGE MICROFINANCE BANK LIMITED</b></p>


        </div>

        <div class="uk-modal-footer uk-text-right">
            <button class="button-34 uk-modal-close" type="button">Cancel</button>
        </div>

    </div>
</div> 

<audio id="sbeep" >
<source src= "https://fullrangemfb.com/frwapp/sounds/succbeep.mp3">
</audio>
<audio id="ebeep" >
<source src= "https://fullrangemfb.com/frwapp/sounds/errorbeep.mp3">
</audio>
<audio id="fbeep" >
<source src= "https://fullrangemfb.com/frwapp/sounds/infobeep.mp3">
</audio>
<audio id="pcproc" >
<source src= "https://fullrangemfb.com/frwapp/sounds/pcproc.mp3">
</audio>
<audio id="pcregsucc" >
<source src= "https://fullrangemfb.com/frwapp/sounds/pcregsucc.mp3">
</audio>
<audio id="errmsg" >
<source src= "https://fullrangemfb.com/frwapp/sounds/errmsg.mp3">
</audio>
<audio id="errlogin" >
<source src= "https://fullrangemfb.com/frwapp/sounds/errlogin.mp3">
</audio>
<audio id="isexist" >
<source src= "https://fullrangemfb.com/frwapp/sounds/isexist.mp3">
</audio>
<audio id="reqmsg" >
<source src= "https://fullrangemfb.com/frwapp/sounds/reqmsg.mp3">
</audio>
<audio id="cpass" >
<source src= "https://pitchcapital.ng/pcwapp/sounds/cpass.mp3">
</audio>
<audio id="emailv" >
<source src= "https://pitchcapital.ng/pcwapp/sounds/emailv.mp3">
</audio>


<script>
   
let passwordInput = document.getElementById("password");
let confirmPasswordInput = document.getElementById("cpassword");
var sbeep = document.getElementById('sbeep');
var emailv = document.getElementById('emailv');
var reqmsg = document.getElementById('reqmsg');
var cpass = document.getElementById('cpass');

function validatePassword() {
  if (passwordInput.value != confirmPasswordInput.value) {
     confirmPasswordInput.focus();
      ebeep.play()
	  cpass.play()
     Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Passwords do not match!',
 
})
 
    return false;
  } else {

    return true;
  }
}

confirmPasswordInput.addEventListener("blur", validatePassword);


let emailInput = document.getElementById("email");

function validateEmail() {
  let email = emailInput.value;
  let emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
  if (!emailRegex.test(email)) {
     emailInput.focus();
     ebeep.play()
	 emailv.play()
    Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Please enter a valid email address',
 
})
    return false;
  } else {
    message.innerHTML = "";
    return true;
  }
}

emailInput.addEventListener("blur", validateEmail);

   
   
      
function mpass(){
    var password  = $('#password');
    var cpassword  = $('#cpassword');
    
    if (password.val() != cpassword.val()) {
                cpassword.focus();
					document.getElementById("msg").innerHtml = "Passwords do not match";
            } else {
               document.getElementById("msg").innerHtml = "Passwords match!";
            }
}									   
		   
$( document ).ready(function() {
       

$("#btnsubmit").click(function() {
    
   var fn  = $('#fn');
   var ln  = $('#ln');
   var bvn  = $('#bvn');
   var email  = $('#email');
   var password  = $('#password');
   var cpassword  = $('#cpassword');
   var gender  = $('#gender');
   var dob  = $('#dob');
   var phoneno  = $('#phoneno');
   var address  = $('#address');
   var bname  = $('#bname');
   var acctno  = $('#acctno');
   var nok  = $('#nok');
   var nor  = $('#nor');
   var nokphoneno  = $('#nokphoneno');
   var nokaddress  = $('#nokaddress');
   var nokstate  = $('#nokstate');
   var estatus  = $('#estatus');
   var mda  = $('#mda');
   var oaddress  = $('#oaddress');
   var loanamt  = $('#loanamt');
   var tenorsel  = $('#tenorsel');
   var lpop  = $('#lpop');
   var mrepay2  = $('#mrepay2');
   var trepay2  = $('#trepay2');
   var tc  = $('#tc');
   var rao  = $('#rao');
   
   var sbeep = document.getElementById('sbeep');
   var ebeep = document.getElementById('ebeep');
   var pcproc = document.getElementById('pcproc');
   var pcregsucc = document.getElementById('pcregsucc');
   var errmsg = document.getElementById('errmsg');
   var errlogin = document.getElementById('errlogin');
   var isexist = document.getElementById('isexist');
   var reqmsg = document.getElementById('reqmsg');
   
   
            
  
   

   if(fn.val() === ''){ 
					 fn.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Kindly enter your first name!',
 
})
    
					return false;
			  }
			   if(ln.val() === ''){ 
					 ln.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Kindly enter your last name!',
 
})
    
					return false;
			  }
			  if(bvn.val() === ''){ 
					 bvn.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'BVN Required!',
 
})
    
					return false;
			  }
			  if(email.val() === ''){ 
					 email.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Kindly enter your email!',
 
})

					return false;
			  }
			   if(password.val() === ''){ 
					 password.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Password required!',
 
})
        
					return false;
			  }
			   if(gender.val() === ''){ 
					 gender.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Gender required!',
 
})
        
					return false;
			  }
 if(dob.val() === ''){ 
					 dob.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Date of birth required!',
 
})
        
					return false;
			  }
if(phoneno.val() === ''){ 
					 phoneno.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Kindly enter your phone number!',
 
})
    
					return false;
			  }
			   if(bname.val() === ''){ 
					 bname.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Bank name required!',
 
})
        
					return false;
			  }
			  if(acctno.val() === ''){ 
					 acctno.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Account number required!',
 
})
        
					return false;
			  }
			   if(nor.val() === ''){ 
					 nor.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Next of kin required!',
 
})
        
					return false;
			  }
			   if(nor.val() === ''){ 
					 nor.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Relationship with Next of kin required!',
 
})
        
					return false;
			  }
			   if(nokphoneno.val() === ''){ 
					 nokphoneno.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Next of kin phoneno required!',
 
})
        
					return false;
			  }
			   if(nokaddress.val() === ''){ 
					 nokaddress.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Next of kin address required!',
 
})
        
					return false;
			  }
			   if(nokstate.val() === ''){ 
					 nokstate.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Next of kin State of residence required!',
 
})
        
					return false;
			  }
			   if(estatus.val() === ''){ 
					 estatus.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Employment status required!',
 
})
        
					return false;
			  }
			   if(mda.val() === ''){ 
					 mda.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'MDA required!',
 
})
        
					return false;
			  }
			   if(oaddress.val() === ''){ 
					 oaddress.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Office Address required!',
 
})
        
					return false;
			  }
			   if(loanamt.val() === ''){ 
					 loanamt.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Loan amount required!',
 
})
        
					return false;
			  }
			   if(tenorsel.val() === ''){ 
					 tenorsel.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Loan tenor required!',
 
})
        
					return false;
			  }
			   if(tc.val() === ''){ 
					 tc.focus();
					 ebeep.play()
					 reqmsg.play()
					   Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: 'Tick box to agree to Terms & Conditions',
 
})
        
					return false;
			  }
   $.ajaxSetup({
					  headers: {
						  'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
					  }
				  });

     // var today = new Date();

      //var date = today.getFullYear()+'-'+(today.getMonth()+1)+'-'+today.getDate();

      //var ddd = document.getElementById('dd').value = date;


      if(fn.val() != '' && ln.val() != '' && bvn.val() != '' &&  email.val() != '' && password.val() != ''  && gender.val() != '' && dob.val() != ''  && phoneno.val() != ''  && bname.val() != ''  && acctno.val() != ''  && nok.val() != ''  && nor.val() != ''  && nokphoneno.val() != ''  && nokaddress.val() != ''  && nokstate.val() != ''  && estatus.val() != ''  && mda.val() != ''  && oaddress.val() != ''  && loanamt.val() != ''  && tenorsel.val() != ''  && tc.val() != '') { 
      
       
		   //btnsu.textContent = 'Please wait...';
           //document.getElementById("btn-signup").disabled = true;
           document.getElementById("overlay").style.display = "block";
           pcproc.play()
           
          $.ajax({
                url: "https://fullrangemfb.com/frwapp/create-user",
                method: 'post',
                data: {
                     fn: $('#fn').val(),
                     ln: $('#ln').val(),
                     bvn: $('#bvn').val(),
                     email: $('#email').val(),
                     password: $('#password').val(),
                     gender: $('#gender').val(),
                     dob: $('#dob').val(),
                     phoneno: $('#phoneno').val(),
                     address: $('#address').val(),
                     bname: $('#bname').val(),
                     acctno: $('#acctno').val(),
                     nok: $('#nok').val(),
                     nor: $('#nor').val(),
                     nokphoneno: $('#nokphoneno').val(),
                     nokaddress: $('#nokaddress').val(),
                     nokstate: $('#nokstate').val(),
                     estatus: $('#estatus').val(),
                     mda: $('#mda').val(),
                     oaddress: $('#oaddress').val(),
                     loanamt: $('#loanamt').val(),
                     tenorsel: $('#tenorsel').val(),
                     lpop: $('#lpop').val(),
                     mrepay2: $('#mrepay2').val(),
                     trepay2: $('#trepay2').val(),
                     tc: $('#tc').val(),
                     rao: $('#rao').val(),
                },
                success: function(result){
                   if(result.success)
                   {
    //btnsu.textContent = 'Signup';
    //document.getElementById("btn-signup").disabled = false;
    document.getElementById("overlay").style.display = "none";
    pcregsucc.play()
                          
Swal.fire({
  icon: 'success',
  title: 'Success',
  text: result.success,
 
}).then(function() {
       
    window.location = "https://fullrangemfb.com/frwapp/user-login";
    //$('#modal-signup').hide();
    //document.getElementById('sulnk').click();
    
});
                   }else{
                         
    //btnsu.textContent = 'Signup';
    //document.getElementById("btn-signup").disabled = false;
    document.getElementById("overlay").style.display = "none";
    ebeep.play()
    errmsg.play()
                      
                         Swal.fire({
  icon: 'error',
  title: 'Oops!',
  text: result.error,
 
}).then(function() {
    //btnsu.textContent = 'Signup';
    //document.getElementById("btn-signup").disabled = false;
    document.getElementById("overlay").style.display = "none";
    ebeep.play()
    //isexist.play()
    
});
             
                          
                   }
                    
                              
                },
  
                error: function(result2){
                  
                  Swal.fire({
  icon: 'error',
  title: 'Oops...',
  text: 'Error!',
 
})
    //btnsu.textContent = 'Signup';
    //document.getElementById("btn-signup").disabled = false;
    document.getElementById("overlay").style.display = "none";
    ebeep.play()
    errmsg.play()
                }
               }); 
  
  
  
        }// End of if

    }); //End Button








     

 });

        </script>
 </body><?php /**PATH /home/fullrang/public_html/frwapp/resources/views/index.blade.php ENDPATH**/ ?>